/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.channel;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.annotation.Resource;
import org.jboss.netty.channel.ChannelException;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddressFactory;
import org.kaazing.k3po.driver.internal.netty.channel.LocationFactory;

public abstract class ChannelAddressFactorySpi {
    private ChannelAddressFactory channelAddressFactory;

    @Resource
    public void setChannelAddressFactory(ChannelAddressFactory channelAddressFactory) {
        this.channelAddressFactory = channelAddressFactory;
    }

    public abstract String getSchemeName();

    public final ChannelAddress newChannelAddress(URI location, Map<String, Object> options) {
        LocationFactory transportFactory;
        URI transportURI;
        int newLocationPort;
        String locationSchemeName = location.getScheme();
        String schemeName = this.getSchemeName();
        if (locationSchemeName == null || !locationSchemeName.equals(schemeName)) {
            throw new ChannelException(String.format("Location scheme %s does not match expected scheme %s", location, schemeName));
        }
        int locationPort = location.getPort();
        if (locationPort == -1 && (newLocationPort = this.getSchemePort()) != -1) {
            try {
                String locationUserInfo = location.getUserInfo();
                String locationHost = location.getHost();
                String locationPath = location.getPath();
                String locationQuery = location.getQuery();
                String locationFragment = location.getFragment();
                location = new URI(locationSchemeName, locationUserInfo, locationHost, newLocationPort, locationPath, locationQuery, locationFragment);
            }
            catch (URISyntaxException e) {
                throw new ChannelException((Throwable)e);
            }
        }
        if ((transportURI = (URI)options.remove("transport")) == null && (transportFactory = this.getTransportFactory()) != null) {
            transportURI = transportFactory.createURI(location);
        }
        ChannelAddress transport = null;
        if (transportURI != null) {
            transport = this.channelAddressFactory.newChannelAddress(transportURI, options);
        }
        return this.newChannelAddress0(location, transport, options);
    }

    protected LocationFactory getTransportFactory() {
        return null;
    }

    protected ChannelAddress newChannelAddress0(URI location, ChannelAddress transport, Map<String, Object> options) {
        return new ChannelAddress(location, transport);
    }

    protected int getSchemePort() {
        return -1;
    }
}

