/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.channel;

import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.kaazing.k3po.driver.internal.netty.channel.DownstreamAbortEvent;
import org.kaazing.k3po.driver.internal.netty.channel.DownstreamFlushEvent;
import org.kaazing.k3po.driver.internal.netty.channel.DownstreamShutdownInputEvent;
import org.kaazing.k3po.driver.internal.netty.channel.DownstreamShutdownOutputEvent;
import org.kaazing.k3po.driver.internal.netty.channel.UpstreamAbortEvent;
import org.kaazing.k3po.driver.internal.netty.channel.UpstreamFlushEvent;
import org.kaazing.k3po.driver.internal.netty.channel.UpstreamShutdownInputEvent;
import org.kaazing.k3po.driver.internal.netty.channel.UpstreamShutdownOutputEvent;

public final class Channels {
    public static void fireInputShutdown(ChannelHandlerContext ctx) {
        ctx.getPipeline().sendUpstream((ChannelEvent)new UpstreamShutdownInputEvent(ctx.getChannel()));
    }

    public static void fireInputShutdown(Channel channel) {
        channel.getPipeline().sendUpstream((ChannelEvent)new UpstreamShutdownInputEvent(channel));
    }

    public static void fireFlushed(Channel channel) {
        channel.getPipeline().sendUpstream((ChannelEvent)new UpstreamFlushEvent(channel));
    }

    public static ChannelFuture shutdownInput(Channel channel) {
        ChannelFuture future = org.jboss.netty.channel.Channels.future((Channel)channel);
        channel.getPipeline().sendDownstream((ChannelEvent)new DownstreamShutdownInputEvent(channel, future));
        return future;
    }

    public static void shutdownInput(ChannelHandlerContext ctx, ChannelFuture future) {
        ctx.sendDownstream((ChannelEvent)new DownstreamShutdownInputEvent(ctx.getChannel(), future));
    }

    public static void fireOutputShutdown(ChannelHandlerContext ctx) {
        ctx.getPipeline().sendUpstream((ChannelEvent)new UpstreamShutdownOutputEvent(ctx.getChannel()));
    }

    public static void fireOutputShutdown(Channel channel) {
        channel.getPipeline().sendUpstream((ChannelEvent)new UpstreamShutdownOutputEvent(channel));
    }

    public static ChannelFuture shutdownOutput(Channel channel) {
        ChannelFuture future = org.jboss.netty.channel.Channels.future((Channel)channel);
        channel.getPipeline().sendDownstream((ChannelEvent)new DownstreamShutdownOutputEvent(channel, future));
        return future;
    }

    public static void shutdownOutput(ChannelHandlerContext ctx, ChannelFuture future) {
        ctx.sendDownstream((ChannelEvent)new DownstreamShutdownOutputEvent(ctx.getChannel(), future));
    }

    public static ChannelFuture flush(Channel channel) {
        ChannelFuture future = org.jboss.netty.channel.Channels.future((Channel)channel);
        channel.getPipeline().sendDownstream((ChannelEvent)new DownstreamFlushEvent(channel, future));
        return future;
    }

    public static void flush(ChannelHandlerContext ctx, ChannelFuture future) {
        ctx.sendDownstream((ChannelEvent)new DownstreamFlushEvent(ctx.getChannel(), future));
    }

    public static ChannelFuture abort(Channel channel) {
        ChannelFuture future = org.jboss.netty.channel.Channels.future((Channel)channel);
        channel.getPipeline().sendDownstream((ChannelEvent)new DownstreamAbortEvent(channel, future));
        return future;
    }

    public static void abort(ChannelHandlerContext ctx, ChannelFuture future) {
        ctx.sendDownstream((ChannelEvent)new DownstreamAbortEvent(ctx.getChannel(), future));
    }

    public static void fireChannelAborted(Channel channel) {
        channel.getPipeline().sendUpstream((ChannelEvent)new UpstreamAbortEvent(channel));
    }

    private Channels() {
    }
}

