/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.channel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelFutureProgressListener;
import org.jboss.netty.channel.DefaultChannelFuture;

public class CompositeChannelFuture<E extends ChannelFuture>
extends DefaultChannelFuture {
    private final NotifyingListener listener = new NotifyingListener();
    private final AtomicInteger unnotified = new AtomicInteger();
    private volatile boolean constructionFinished;
    private final Collection<E> kids;
    private volatile int successCount;
    private volatile int failedCount;
    private volatile int cancelledCount;
    private final boolean failFast;

    public CompositeChannelFuture(Channel channel, Collection<E> kids) {
        this(channel, kids, false);
    }

    public CompositeChannelFuture(Channel channel, Collection<E> kids, boolean failFast) {
        super(channel, false);
        this.failFast = failFast;
        this.kids = Collections.unmodifiableCollection(new ArrayList<E>(kids));
        for (ChannelFuture k : kids) {
            this.unnotified.incrementAndGet();
            k.addListener((ChannelFutureListener)this.listener);
        }
        this.constructionFinished = true;
        if (this.unnotified.get() == 0) {
            this.setSuccess();
        }
    }

    public Throwable getCause() {
        Throwable t = super.getCause();
        if (t != null) {
            return t;
        }
        for (ChannelFuture future : this.kids) {
            t = future.getCause();
            if (t == null) continue;
            if (this.failFast) {
                this.setFailure(t);
            }
            return t;
        }
        return null;
    }

    public boolean isSuccess() {
        if (super.isSuccess()) {
            return true;
        }
        boolean result = this.allTrue(new CompositeTrue(){

            @Override
            public boolean isTrue(ChannelFuture f) {
                return f.isSuccess();
            }
        });
        return result;
    }

    public boolean isDone() {
        if (super.isDone()) {
            return true;
        }
        return this.allTrue(new CompositeTrue(){

            @Override
            public boolean isTrue(ChannelFuture f) {
                return f.isDone();
            }
        });
    }

    public String toString() {
        StringBuffer s = new StringBuffer(super.toString());
        s.append(" (");
        s.append(CompositeChannelFuture.futureStatus((ChannelFuture)this));
        s.append(", " + this.kids.size() + " kids)");
        for (ChannelFuture kid : this.kids) {
            s.append("\n  ");
            s.append(kid.toString());
            s.append(" (");
            s.append(CompositeChannelFuture.futureStatus(kid));
            s.append(")");
        }
        return s.toString();
    }

    private static String futureStatus(ChannelFuture future) {
        return future.isSuccess() ? "success" : (future.isCancelled() ? "cancelled" : (future.getCause() == null ? "incomplete" : "failed - " + future.getCause()));
    }

    private boolean allTrue(CompositeTrue predicate) {
        if (this.kids.isEmpty()) {
            return false;
        }
        for (ChannelFuture future : this.kids) {
            if (predicate.isTrue(future)) continue;
            return false;
        }
        return true;
    }

    private class NotifyingListener
    implements ChannelFutureListener,
    ChannelFutureProgressListener {
        private NotifyingListener() {
        }

        public void operationProgressed(ChannelFuture future, long amount, long current, long total) throws Exception {
            if (CompositeChannelFuture.this.constructionFinished) {
                CompositeChannelFuture.this.setProgress(amount, current, total);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void operationComplete(ChannelFuture future) {
            boolean isSuccess = future.isSuccess();
            boolean isCancelled = future.isCancelled();
            boolean failed = false;
            CompositeChannelFuture compositeChannelFuture = CompositeChannelFuture.this;
            synchronized (compositeChannelFuture) {
                if (CompositeChannelFuture.super.isDone()) {
                    return;
                }
                int currentUnnotified = CompositeChannelFuture.this.unnotified.decrementAndGet();
                if (isSuccess) {
                    CompositeChannelFuture.this.successCount++;
                } else if (isCancelled) {
                    CompositeChannelFuture.this.cancelledCount++;
                } else {
                    failed = true;
                    CompositeChannelFuture.this.failedCount++;
                }
                if (currentUnnotified == 0 && CompositeChannelFuture.this.constructionFinished) {
                    int totalKids = CompositeChannelFuture.this.kids.size();
                    if (totalKids == CompositeChannelFuture.this.successCount) {
                        CompositeChannelFuture.this.setSuccess();
                    } else if (totalKids == CompositeChannelFuture.this.cancelledCount) {
                        if (!CompositeChannelFuture.this.cancel() && !CompositeChannelFuture.this.isCancelled()) {
                            CompositeChannelFuture.this.setSuccess();
                        }
                    } else {
                        for (ChannelFuture f : CompositeChannelFuture.this.kids) {
                            Throwable t = f.getCause();
                            if (t == null) continue;
                            CompositeChannelFuture.this.setFailure(t);
                            return;
                        }
                    }
                } else if (failed && CompositeChannelFuture.this.failFast && CompositeChannelFuture.this.constructionFinished) {
                    CompositeChannelFuture.this.setFailure(future.getCause());
                }
            }
        }
    }

    private static interface CompositeTrue {
        public boolean isTrue(ChannelFuture var1);
    }
}

