/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.channel;

import java.net.URI;
import java.net.URISyntaxException;
import org.kaazing.k3po.driver.internal.netty.channel.LocationFactory;

public abstract class LocationFactories {
    private LocationFactories() {
    }

    public static LocationFactory keepAuthorityOnly(String newScheme) {
        return new KeepAuthorityOnlyTransportFactory(newScheme);
    }

    public static LocationFactory changeSchemeOnly(String newScheme) {
        return new ChangeSchemeOnlyTransportFactory(newScheme);
    }

    private static final class ChangeSchemeOnlyTransportFactory
    extends LocationFactory {
        private final String newScheme;

        public ChangeSchemeOnlyTransportFactory(String newScheme) {
            this.newScheme = newScheme;
        }

        @Override
        public URI createURI(URI location) {
            String scheme = location.getScheme();
            if (this.newScheme.equals(scheme)) {
                return location;
            }
            String authority = location.getAuthority();
            String path = location.getPath();
            String query = location.getQuery();
            String fragment = location.getFragment();
            try {
                return new URI(this.newScheme, authority, path, query, fragment);
            }
            catch (URISyntaxException x) {
                IllegalArgumentException y = new IllegalArgumentException();
                y.initCause(x);
                throw y;
            }
        }
    }

    private static final class KeepAuthorityOnlyTransportFactory
    extends LocationFactory {
        private final String newScheme;

        public KeepAuthorityOnlyTransportFactory(String newScheme) {
            this.newScheme = newScheme;
        }

        private static int getDefaultPortForScheme(String scheme) {
            switch (scheme) {
                case "http": {
                    return 80;
                }
                case "https": {
                    return 443;
                }
            }
            return -1;
        }

        @Override
        public URI createURI(URI location) {
            URI result;
            if (location.getPort() == -1) {
                int port = KeepAuthorityOnlyTransportFactory.getDefaultPortForScheme(location.getScheme());
                result = URI.create(String.format("%s://%s:%d", this.newScheme, location.getAuthority(), port));
            } else {
                result = URI.create(String.format("%s://%s", this.newScheme, location.getAuthority()));
            }
            return result;
        }
    }
}

