/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.channel.agrona;

import java.net.URI;
import java.util.Map;
import org.jboss.netty.channel.ChannelException;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddressFactorySpi;
import org.kaazing.k3po.driver.internal.netty.channel.agrona.AgronaChannelAddress;
import org.kaazing.k3po.driver.internal.netty.channel.agrona.ChannelReader;
import org.kaazing.k3po.driver.internal.netty.channel.agrona.ChannelWriter;

public class AgronaChannelAddressFactorySpi
extends ChannelAddressFactorySpi {
    @Override
    public String getSchemeName() {
        return "agrona";
    }

    @Override
    protected ChannelAddress newChannelAddress0(URI location, ChannelAddress transport, Map<String, Object> options) {
        String host = location.getHost();
        int port = location.getPort();
        String path = location.getPath();
        if (host == null) {
            throw new ChannelException(String.format("%s host missing", this.getSchemeName()));
        }
        if (port != -1) {
            throw new ChannelException(String.format("%s port unexpected", this.getSchemeName()));
        }
        if (path == null || path.isEmpty()) {
            throw new ChannelException(String.format("%s path missing", this.getSchemeName()));
        }
        if (!"stream".equals(host)) {
            throw new ChannelException(String.format("%s host is not 'stream'", this.getSchemeName()));
        }
        if (!"/bidirectional".equals(path)) {
            throw new ChannelException(String.format("%s path is not '/bidirectional'", this.getSchemeName()));
        }
        if (options == null || !options.containsKey("reader")) {
            throw new ChannelException(String.format("%s reader option missing", this.getSchemeName()));
        }
        Object reader = options.get("reader");
        if (!(reader instanceof ChannelReader)) {
            throw new ChannelException(String.format("%s reader option incorrect type", this.getSchemeName()));
        }
        if (options == null || !options.containsKey("writer")) {
            throw new ChannelException(String.format("%s writer option missing", this.getSchemeName()));
        }
        Object writer = options.get("writer");
        if (!(writer instanceof ChannelWriter)) {
            throw new ChannelException(String.format("%s reader option incorrect type", this.getSchemeName()));
        }
        return new AgronaChannelAddress(location, (ChannelReader)reader, (ChannelWriter)writer);
    }
}

