/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.channel.file;

import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;

public class FileChannelAddress
extends ChannelAddress {
    private static final long serialVersionUID = 1L;
    private final String mode;
    private final long size;

    public FileChannelAddress(URI location, Map<String, Object> options) {
        super(location);
        String mode = (String)options.get("mode");
        this.mode = mode == null ? "rw" : mode;
        Long size = (Long)options.get("size");
        this.size = size == null ? 0L : size;
    }

    public String mode() {
        return this.mode;
    }

    public long size() {
        return this.size;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof FileChannelAddress) {
            FileChannelAddress that = (FileChannelAddress)o;
            return Objects.equals(this.mode, that.mode) && this.size == that.size && super.equals(o);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (int)((long)(super.hashCode() + this.mode.hashCode()) + this.size);
    }
}

