/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.channel.udp;

import java.net.URI;
import java.util.Map;
import org.jboss.netty.channel.ChannelException;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddressFactorySpi;
import org.kaazing.k3po.driver.internal.netty.channel.udp.UdpChannelAddress;

public class UdpChannelAddressFactorySpi
extends ChannelAddressFactorySpi {
    @Override
    public String getSchemeName() {
        return "udp";
    }

    @Override
    protected ChannelAddress newChannelAddress0(URI location, ChannelAddress transport, Map<String, Object> options) {
        String host = location.getHost();
        int port = location.getPort();
        String path = location.getPath();
        if (host == null) {
            throw new ChannelException(String.format("%s host missing", this.getSchemeName()));
        }
        if (port == -1) {
            throw new ChannelException(String.format("%s port missing", this.getSchemeName()));
        }
        if (path != null && !path.isEmpty()) {
            throw new ChannelException(String.format("%s path \"%s\" unexpected", this.getSchemeName(), path));
        }
        Long timeout = (Long)options.get("timeout");
        long timeoutValue = timeout == null ? 0L : timeout;
        return new UdpChannelAddress(location, transport, timeoutValue);
    }
}

