/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.resolver;

import java.net.URI;
import java.util.Map;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.k3po.driver.internal.behavior.Barrier;
import org.kaazing.k3po.driver.internal.netty.bootstrap.BootstrapFactory;
import org.kaazing.k3po.driver.internal.netty.bootstrap.ClientBootstrap;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddressFactory;
import org.kaazing.k3po.driver.internal.resolver.LocationResolver;
import org.kaazing.k3po.driver.internal.resolver.OptionsResolver;
import org.kaazing.k3po.lang.internal.RegionInfo;

public class ClientBootstrapResolver {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(ClientBootstrapResolver.class);
    private final BootstrapFactory bootstrapFactory;
    private final ChannelAddressFactory addressFactory;
    private final ChannelPipelineFactory pipelineFactory;
    private final LocationResolver locationResolver;
    private final Barrier awaitBarrier;
    private final RegionInfo regionInfo;
    private final OptionsResolver optionsResolver;
    private ClientBootstrap bootstrap;

    public ClientBootstrapResolver(BootstrapFactory bootstrapFactory, ChannelAddressFactory addressFactory, ChannelPipelineFactory pipelineFactory, LocationResolver locationResolver, OptionsResolver optionsResolver, Barrier awaitBarrier, RegionInfo regionInfo) {
        this.bootstrapFactory = bootstrapFactory;
        this.addressFactory = addressFactory;
        this.pipelineFactory = pipelineFactory;
        this.locationResolver = locationResolver;
        this.optionsResolver = optionsResolver;
        this.awaitBarrier = awaitBarrier;
        this.regionInfo = regionInfo;
    }

    public ClientBootstrap resolve() throws Exception {
        if (this.bootstrap == null) {
            URI connectURI = this.locationResolver.resolve();
            Map<String, Object> connectOptions = this.optionsResolver.resolve();
            ChannelAddress remoteAddress = this.addressFactory.newChannelAddress(connectURI, connectOptions);
            LOGGER.debug("Initializing client Bootstrap connecting to remoteAddress " + remoteAddress);
            ClientBootstrap clientBootstrapCandidate = this.bootstrapFactory.newClientBootstrap(connectURI.getScheme());
            clientBootstrapCandidate.setPipelineFactory(this.pipelineFactory);
            clientBootstrapCandidate.setOption("remoteAddress", remoteAddress);
            this.bootstrap = clientBootstrapCandidate;
        }
        return this.bootstrap;
    }

    public Barrier getAwaitBarrier() {
        return this.awaitBarrier;
    }

    public RegionInfo getRegionInfo() {
        return this.regionInfo;
    }
}

