/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.resolver;

import java.net.URI;
import javax.el.ELContext;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.k3po.lang.internal.ast.value.AstLocation;
import org.kaazing.k3po.lang.internal.ast.value.AstLocationExpression;
import org.kaazing.k3po.lang.internal.ast.value.AstLocationLiteral;

public class LocationResolver {
    private static final LocationVisitorImpl VISITOR = new LocationVisitorImpl();
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(LocationResolver.class);
    private final AstLocation location;
    private final ELContext environment;
    private URI evaluatedURI;

    public LocationResolver(AstLocation location, ELContext environment) {
        this.location = location;
        this.environment = environment;
    }

    public URI resolve() throws Exception {
        if (this.evaluatedURI == null) {
            this.evaluatedURI = (URI)this.location.accept((AstLocation.Visitor)VISITOR, (Object)this.environment);
        }
        return this.evaluatedURI;
    }

    private static class LocationVisitorImpl
    implements AstLocation.Visitor<URI, ELContext> {
        private LocationVisitorImpl() {
        }

        public URI visit(AstLocationLiteral value, ELContext parameter) throws Exception {
            return value.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public URI visit(AstLocationExpression value, ELContext environment) throws Exception {
            Object location;
            try {
                ELContext eLContext = environment;
                synchronized (eLContext) {
                    ValueExpression expression = value.getValue();
                    location = expression.getValue(environment);
                }
            }
            catch (PropertyNotFoundException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                location = null;
            }
            if (location == null) {
                throw new NullPointerException("Location expression result is null");
            }
            return (URI)location;
        }
    }
}

