/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.resolver;

import java.util.HashMap;
import java.util.Map;
import javax.el.ELContext;
import org.kaazing.k3po.lang.internal.ast.value.AstExpressionValue;
import org.kaazing.k3po.lang.internal.ast.value.AstLocationExpression;
import org.kaazing.k3po.lang.internal.ast.value.AstLocationLiteral;

public final class OptionsResolver {
    private final Map<String, Object> options;
    private final ELContext environment;
    private Map<String, Object> resolved;

    public OptionsResolver(Map<String, Object> options, ELContext environment) {
        this.options = options;
        this.environment = environment;
    }

    public Map<String, Object> resolve() {
        if (this.resolved == null) {
            this.resolved = new HashMap<String, Object>();
            for (String name : this.options.keySet()) {
                AstLocationExpression location;
                Object value = this.options.get(name);
                if (value instanceof AstExpressionValue) {
                    AstExpressionValue expressionValue = (AstExpressionValue)value;
                    value = expressionValue.getValue().getValue(this.environment);
                } else if (value instanceof AstLocationExpression) {
                    location = (AstLocationExpression)value;
                    value = location.getValue().getValue(this.environment);
                } else if (value instanceof AstLocationLiteral) {
                    location = (AstLocationLiteral)value;
                    value = location.getValue();
                }
                this.resolved.put(name, value);
            }
        }
        return this.resolved;
    }
}

