/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.resolver;

import java.net.URI;
import java.util.Map;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.k3po.driver.internal.behavior.Barrier;
import org.kaazing.k3po.driver.internal.netty.bootstrap.BootstrapFactory;
import org.kaazing.k3po.driver.internal.netty.bootstrap.ServerBootstrap;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddressFactory;
import org.kaazing.k3po.driver.internal.resolver.ClientBootstrapResolver;
import org.kaazing.k3po.driver.internal.resolver.LocationResolver;
import org.kaazing.k3po.driver.internal.resolver.OptionsResolver;

public class ServerBootstrapResolver {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(ClientBootstrapResolver.class);
    private final BootstrapFactory bootstrapFactory;
    private final ChannelAddressFactory addressFactory;
    private final ChannelPipelineFactory pipelineFactory;
    private final LocationResolver locationResolver;
    private final OptionsResolver optionsResolver;
    private final Barrier notifyBarrier;
    private ServerBootstrap bootstrap;

    public ServerBootstrapResolver(BootstrapFactory bootstrapFactory, ChannelAddressFactory addressFactory, ChannelPipelineFactory pipelineFactory, LocationResolver locationResolver, OptionsResolver optionsResolver, Barrier notifyBarrier) {
        this.bootstrapFactory = bootstrapFactory;
        this.addressFactory = addressFactory;
        this.pipelineFactory = pipelineFactory;
        this.locationResolver = locationResolver;
        this.optionsResolver = optionsResolver;
        this.notifyBarrier = notifyBarrier;
    }

    public Barrier getNotifyBarrier() {
        return this.notifyBarrier;
    }

    public ServerBootstrap resolve() throws Exception {
        if (this.bootstrap == null) {
            URI acceptURI = this.locationResolver.resolve();
            Map<String, Object> acceptOptions = this.optionsResolver.resolve();
            ChannelAddress localAddress = this.addressFactory.newChannelAddress(acceptURI, acceptOptions);
            LOGGER.debug("Initializing server Bootstrap binding to address " + localAddress);
            ServerBootstrap serverBootstrapCandidate = this.bootstrapFactory.newServerBootstrap(acceptURI.getScheme());
            acceptOptions.put("localAddress", localAddress);
            serverBootstrapCandidate.setOptions(acceptOptions);
            serverBootstrapCandidate.setPipelineFactory(this.pipelineFactory);
            this.bootstrap = serverBootstrapCandidate;
        }
        return this.bootstrap;
    }
}

