/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.junit.rules;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.rules.Verifier;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runners.model.Statement;
import org.kaazing.k3po.junit.annotation.Robotic;
import org.kaazing.k3po.junit.rules.RoboticLatch;
import org.kaazing.k3po.junit.rules.RoboticStatement;
import org.kaazing.net.URLFactory;

public final class RobotRule
extends Verifier {
    private final RoboticLatch latch = new RoboticLatch();
    private String scriptRoot;
    private URL controlURL;

    public RobotRule setScriptRoot(String scriptRoot) {
        this.scriptRoot = scriptRoot;
        return this;
    }

    public RobotRule setControlURI(URI controlURI) {
        this.controlURL = RobotRule.createURL(controlURI.toString());
        return this;
    }

    public Statement apply(Statement statement, Description description) {
        Robotic note = (Robotic)description.getAnnotation(Robotic.class);
        if (note != null) {
            String packagePath = this.scriptRoot;
            if (packagePath == null) {
                Class testClass = description.getTestClass();
                String packageName = testClass.getPackage().getName();
                packagePath = packageName.replaceAll("\\.", "/");
            }
            String[] scripts = note.value();
            LinkedList<String> scriptNames = new LinkedList<String>();
            for (int i = 0; i < scripts.length; ++i) {
                if (scripts[i].startsWith("/")) {
                    throw new IllegalArgumentException("Script path must be relative");
                }
                String scriptName = String.format("%s/%s", packagePath, scripts[i]);
                scriptNames.add(scriptName);
            }
            URL controlURL = this.controlURL;
            if (controlURL == null) {
                controlURL = RobotRule.createURL("tcp://localhost:11642");
            }
            statement = new RoboticStatement(statement, controlURL, scriptNames, this.latch);
        }
        return super.apply(statement, description);
    }

    public void join() throws Exception {
        Assert.assertTrue((String)"Did you call join() from outside @Robotic test?", (boolean)this.latch.isPrepared());
        this.latch.notifyStartable();
        this.latch.awaitFinished();
    }

    private static URL createURL(String location) {
        try {
            return URLFactory.createURL((String)"tcp://localhost:11642");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        JUnitCore core = new JUnitCore();
        String version = core.getVersion();
        String[] versionTokens = version.split("\\.");
        Integer[] versionsInt = new Integer[versionTokens.length];
        for (int i = 0; i < versionTokens.length; ++i) {
            String versionToken = versionTokens[i];
            if (versionToken.contains("-")) {
                versionToken = versionToken.substring(0, versionToken.indexOf("-"));
            }
            versionsInt[i] = Integer.parseInt(versionToken);
        }
        if (versionsInt[0] < 5 && (versionsInt.length == 1 || versionsInt[0] < 4 || versionsInt[1] < 10)) {
            throw new AssertionError((Object)("Robot Junit library requires at least version 4.10. Found version " + version));
        }
    }
}

