/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.junit.rules;

import java.util.concurrent.CountDownLatch;

class RoboticLatch {
    private volatile State state = State.INIT;
    private volatile Exception exception;
    private final CountDownLatch prepared = new CountDownLatch(1);
    private final CountDownLatch startable = new CountDownLatch(1);
    private final CountDownLatch finished = new CountDownLatch(1);

    RoboticLatch() {
    }

    void notifyPrepared() {
        switch (this.state) {
            case INIT: {
                this.state = State.PREPARED;
                this.prepared.countDown();
                break;
            }
            default: {
                throw new IllegalStateException(this.state.name());
            }
        }
    }

    void awaitPrepared() throws Exception {
        this.prepared.await();
        if (this.exception != null) {
            throw this.exception;
        }
    }

    boolean isPrepared() {
        return this.prepared.getCount() == 0L;
    }

    void notifyStartable() {
        switch (this.state) {
            case PREPARED: {
                this.state = State.STARTABLE;
                this.startable.countDown();
                break;
            }
            default: {
                throw new IllegalStateException(this.state.name());
            }
        }
    }

    void awaitStartable() throws Exception {
        this.startable.await();
        if (this.exception != null) {
            throw this.exception;
        }
    }

    boolean isStartable() {
        return this.startable.getCount() == 0L;
    }

    void notifyFinished() {
        switch (this.state) {
            case INIT: {
                this.notifyPrepared();
                break;
            }
            case PREPARED: 
            case STARTABLE: {
                this.state = State.FINISHED;
                this.finished.countDown();
                break;
            }
            default: {
                throw new IllegalStateException(this.state.name());
            }
        }
    }

    void notifyAbort() {
        switch (this.state) {
            case INIT: {
                this.notifyPrepared();
            }
            case PREPARED: {
                this.notifyStartable();
                break;
            }
        }
    }

    void awaitFinished() throws Exception {
        this.finished.await();
        if (this.exception != null) {
            throw this.exception;
        }
    }

    boolean isFinished() {
        return this.finished.getCount() == 0L;
    }

    boolean hasException() {
        return this.exception != null;
    }

    void notifyException(Exception exception) {
        this.exception = exception;
        this.prepared.countDown();
        this.startable.countDown();
        this.finished.countDown();
    }

    static enum State {
        INIT,
        PREPARED,
        STARTABLE,
        FINISHED;

    }
}

