/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.junit.rules;

import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.junit.runners.model.Statement;
import org.kaazing.k3po.junit.rules.RobotRule;
import org.kaazing.k3po.junit.rules.RoboticLatch;
import org.kaazing.k3po.junit.rules.ScriptPair;
import org.kaazing.k3po.junit.rules.ScriptRunner;

final class RoboticStatement
extends Statement {
    private final Statement statement;
    private final URL controlURL;
    private final List<String> scriptNames;
    private final RoboticLatch latch;

    RoboticStatement(Statement statement, URL controlURL, List<String> scriptNames, RoboticLatch latch) {
        this.statement = statement;
        this.controlURL = controlURL;
        this.scriptNames = scriptNames;
        this.latch = latch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate() throws Throwable {
        ScriptRunner scriptRunner = new ScriptRunner(this.controlURL, this.scriptNames, this.latch);
        FutureTask<ScriptPair> scriptFuture = new FutureTask<ScriptPair>(scriptRunner);
        try {
            new Thread(scriptFuture).start();
            this.latch.awaitPrepared();
            try {
                this.statement.evaluate();
            }
            catch (Throwable cause) {
                if (this.latch.hasException()) {
                    throw cause;
                }
                if (!this.latch.isFinished()) {
                    scriptRunner.abort();
                }
                try {
                    ScriptPair scripts = scriptFuture.get(5L, TimeUnit.SECONDS);
                    try {
                        Assert.assertEquals((String)"Robotic behavior did not match", (Object)scripts.getExpectedScript(), (Object)scripts.getObservedScript());
                        throw cause;
                    }
                    catch (ComparisonFailure f) {
                        f.initCause(cause);
                        throw f;
                    }
                }
                catch (ExecutionException ee) {
                    throw ee.getCause().initCause(cause);
                }
                catch (Exception e) {
                    throw cause;
                }
            }
            Assert.assertTrue((String)String.format("Did you call %s.join()?", RobotRule.class.getSimpleName()), (boolean)this.latch.isStartable());
            ScriptPair scripts = scriptFuture.get();
            Assert.assertEquals((String)"Robotic behavior did not match expected", (Object)scripts.getExpectedScript(), (Object)scripts.getObservedScript());
        }
        finally {
            scriptFuture.cancel(true);
        }
    }
}

