/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.junit.rules;

import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.kaazing.k3po.junit.rules.RoboticException;
import org.kaazing.k3po.junit.rules.RoboticLatch;
import org.kaazing.k3po.junit.rules.ScriptPair;
import org.kaazing.k3po.junit.shaded.control.RobotControl;
import org.kaazing.k3po.junit.shaded.control.command.AbortCommand;
import org.kaazing.k3po.junit.shaded.control.command.Command;
import org.kaazing.k3po.junit.shaded.control.command.PrepareCommand;
import org.kaazing.k3po.junit.shaded.control.command.StartCommand;
import org.kaazing.k3po.junit.shaded.control.event.CommandEvent;
import org.kaazing.k3po.junit.shaded.control.event.ErrorEvent;
import org.kaazing.k3po.junit.shaded.control.event.FinishedEvent;
import org.kaazing.k3po.junit.shaded.control.event.PreparedEvent;

final class ScriptRunner
implements Callable<ScriptPair> {
    private final RobotControl controller;
    private final List<String> names;
    private final RoboticLatch latch;
    private volatile boolean abortScheduled;

    ScriptRunner(URL controlURL, List<String> names, RoboticLatch latch) throws Exception {
        if (names == null) {
            throw new NullPointerException("names");
        }
        if (latch == null) {
            throw new NullPointerException("latch");
        }
        this.controller = new RobotControl(controlURL);
        this.names = names;
        this.latch = latch;
    }

    public void abort() {
        this.abortScheduled = true;
        this.latch.notifyAbort();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ScriptPair call() throws Exception {
        try {
            if (this.abortScheduled) {
                ScriptPair scriptPair = new ScriptPair();
                return scriptPair;
            }
            this.controller.connect();
            PrepareCommand prepare = new PrepareCommand();
            prepare.setNames(this.names);
            this.controller.writeCommand((Command)prepare);
            boolean abortWritten = false;
            String expectedScript = null;
            block17: while (true) {
                CommandEvent event = this.controller.readEvent(200, TimeUnit.MILLISECONDS);
                switch (event.getKind()) {
                    case PREPARED: {
                        PreparedEvent prepared = (PreparedEvent)event;
                        expectedScript = prepared.getScript();
                        this.latch.notifyPrepared();
                        this.latch.awaitStartable();
                        if (this.abortScheduled && !abortWritten) {
                            this.sendAbortCommand();
                            abortWritten = true;
                            continue block17;
                        }
                        StartCommand start = new StartCommand();
                        this.controller.writeCommand((Command)start);
                        continue block17;
                    }
                    case STARTED: {
                        continue block17;
                    }
                    case ERROR: {
                        ErrorEvent error = (ErrorEvent)event;
                        throw new RoboticException(String.format("%s:%s", error.getSummary(), error.getDescription()));
                    }
                    case FINISHED: {
                        FinishedEvent finished = (FinishedEvent)event;
                        String observedScript = finished.getScript();
                        ScriptPair scriptPair = new ScriptPair(expectedScript, observedScript);
                        return scriptPair;
                    }
                }
                {
                    catch (SocketTimeoutException e) {
                        if (this.abortScheduled && !abortWritten) {
                            this.sendAbortCommand();
                            abortWritten = true;
                        }
                        if (Thread.interrupted()) throw new InterruptedException();
                        continue;
                    }
                }
                throw new IllegalArgumentException("Unrecognized event kind: " + (Object)((Object)event.getKind()));
                break;
            }
            catch (ConnectException e) {
                Exception exception = new Exception("Failed to connect. Is the Robot running?", e);
                exception.fillInStackTrace();
                this.latch.notifyException(exception);
                throw e;
            }
            catch (Exception e) {
                this.latch.notifyException(e);
                throw e;
            }
        }
        finally {
            this.latch.notifyFinished();
            this.controller.disconnect();
        }
    }

    private void sendAbortCommand() throws Exception {
        AbortCommand abort = new AbortCommand();
        this.controller.writeCommand((Command)abort);
    }
}

