/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.junit.shaded.control;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kaazing.k3po.junit.shaded.control.command.AbortCommand;
import org.kaazing.k3po.junit.shaded.control.command.Command;
import org.kaazing.k3po.junit.shaded.control.command.PrepareCommand;
import org.kaazing.k3po.junit.shaded.control.command.StartCommand;
import org.kaazing.k3po.junit.shaded.control.event.CommandEvent;
import org.kaazing.k3po.junit.shaded.control.event.ErrorEvent;
import org.kaazing.k3po.junit.shaded.control.event.FinishedEvent;
import org.kaazing.k3po.junit.shaded.control.event.PreparedEvent;
import org.kaazing.k3po.junit.shaded.control.event.StartedEvent;

public final class RobotControl {
    private static final String FINISHED_EVENT = "FINISHED";
    private static final String ERROR_EVENT = "ERROR";
    private static final String STARTED_EVENT = "STARTED";
    private static final String PREPARED_EVENT = "PREPARED";
    private static final Pattern HEADER_PATTERN = Pattern.compile("([a-z\\-]+):([^\n]+)");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final URL location;
    private URLConnection connection;
    BufferedReader textIn;

    public RobotControl(URL location) {
        this.location = location;
    }

    public void connect() throws Exception {
        this.connection = this.location.openConnection();
        this.connection.connect();
        InputStream bytesIn = this.connection.getInputStream();
        CharsetDecoder decoder = UTF_8.newDecoder();
        this.textIn = new BufferedReader(new InputStreamReader(bytesIn, decoder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws Exception {
        block9: {
            if (this.connection != null) {
                try {
                    if (this.connection instanceof Closeable) {
                        ((Closeable)((Object)this.connection)).close();
                        break block9;
                    }
                    try {
                        this.connection.getInputStream().close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    try {
                        this.connection.getOutputStream().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                finally {
                    this.connection = null;
                }
            }
        }
    }

    public void writeCommand(Command command) throws Exception {
        this.checkConnected();
        switch (command.getKind()) {
            case PREPARE: {
                this.writeCommand((PrepareCommand)command);
                break;
            }
            case START: {
                this.writeCommand((StartCommand)command);
                break;
            }
            case ABORT: {
                this.writeCommand((AbortCommand)command);
                break;
            }
            default: {
                throw new IllegalArgumentException("Urecognized command kind: " + (Object)((Object)command.getKind()));
            }
        }
    }

    public CommandEvent readEvent() throws Exception {
        return this.readEvent(0, TimeUnit.MILLISECONDS);
    }

    public CommandEvent readEvent(int timeout, TimeUnit unit) throws Exception {
        this.checkConnected();
        this.connection.setReadTimeout((int)unit.toMillis(timeout));
        String eventType = this.textIn.readLine();
        if (eventType != null) {
            switch (eventType) {
                case "PREPARED": {
                    return this.readPreparedEvent();
                }
                case "STARTED": {
                    return this.readStartedEvent();
                }
                case "ERROR": {
                    return this.readErrorEvent();
                }
                case "FINISHED": {
                    return this.readFinishedEvent();
                }
            }
        }
        throw new IllegalStateException("Invalid protocol frame: " + eventType);
    }

    private void checkConnected() throws Exception {
        if (this.connection == null) {
            throw new IllegalStateException("Not connected");
        }
    }

    private void writeCommand(PrepareCommand prepare) throws Exception {
        OutputStream bytesOut = this.connection.getOutputStream();
        CharsetEncoder encoder = UTF_8.newEncoder();
        OutputStreamWriter textOut = new OutputStreamWriter(bytesOut, encoder);
        List<String> names = prepare.getNames();
        ((Writer)textOut).append("PREPARE\n");
        ((Writer)textOut).append("version:2.0\n");
        for (String name : names) {
            ((Writer)textOut).append(String.format("name:%s\n", name));
        }
        ((Writer)textOut).append("\n");
        ((Writer)textOut).flush();
    }

    private void writeCommand(StartCommand start) throws Exception {
        OutputStream bytesOut = this.connection.getOutputStream();
        CharsetEncoder encoder = UTF_8.newEncoder();
        OutputStreamWriter textOut = new OutputStreamWriter(bytesOut, encoder);
        ((Writer)textOut).append("START\n");
        ((Writer)textOut).append("\n");
        ((Writer)textOut).flush();
    }

    private void writeCommand(AbortCommand abort) throws IOException, CharacterCodingException {
        OutputStream bytesOut = this.connection.getOutputStream();
        CharsetEncoder encoder = UTF_8.newEncoder();
        OutputStreamWriter textOut = new OutputStreamWriter(bytesOut, encoder);
        ((Writer)textOut).append("ABORT\n");
        ((Writer)textOut).append("\n");
        ((Writer)textOut).flush();
    }

    private PreparedEvent readPreparedEvent() throws IOException {
        String line;
        PreparedEvent prepared = new PreparedEvent();
        int length = -1;
        do {
            Matcher matcher;
            if (!(matcher = HEADER_PATTERN.matcher(line = this.textIn.readLine())).matches()) continue;
            String headerName = matcher.group(1);
            String headerValue = matcher.group(2);
            switch (headerName) {
                case "content-length": {
                    length = Integer.parseInt(headerValue);
                    break;
                }
                case "name": {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized event header: " + headerName);
                }
            }
        } while (!line.isEmpty());
        if (length >= 0) {
            prepared.setScript(this.readContent(length));
        }
        return prepared;
    }

    private StartedEvent readStartedEvent() throws IOException {
        String line;
        StartedEvent started = new StartedEvent();
        do {
            String headerName;
            Matcher matcher;
            if (!(matcher = HEADER_PATTERN.matcher(line = this.textIn.readLine())).matches()) continue;
            switch (headerName = matcher.group(1)) {
                case "name": {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized event header: " + headerName);
                }
            }
        } while (!line.isEmpty());
        return started;
    }

    private FinishedEvent readFinishedEvent() throws IOException {
        String line;
        FinishedEvent finished = new FinishedEvent();
        int length = -1;
        do {
            Matcher matcher;
            if (!(matcher = HEADER_PATTERN.matcher(line = this.textIn.readLine())).matches()) continue;
            String headerName = matcher.group(1);
            String headerValue = matcher.group(2);
            switch (headerName) {
                case "content-length": {
                    length = Integer.parseInt(headerValue);
                    break;
                }
                case "name": {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized event header: " + headerName);
                }
            }
        } while (!line.isEmpty());
        if (length >= 0) {
            finished.setScript(this.readContent(length));
        }
        return finished;
    }

    private ErrorEvent readErrorEvent() throws IOException {
        String line;
        ErrorEvent error = new ErrorEvent();
        int length = 0;
        do {
            Matcher matcher;
            if (!(matcher = HEADER_PATTERN.matcher(line = this.textIn.readLine())).matches()) continue;
            String headerName = matcher.group(1);
            String headerValue = matcher.group(2);
            switch (headerName) {
                case "content-length": {
                    length = Integer.parseInt(headerValue);
                    break;
                }
                case "summary": {
                    error.setSummary(headerValue);
                    break;
                }
                case "name": {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized event header: " + headerName);
                }
            }
        } while (!line.isEmpty());
        if (length > 0) {
            error.setDescription(this.readContent(length));
        }
        return error;
    }

    private String readContent(int length) throws IOException {
        int result;
        char[] content = new char[length];
        int bytesRead = 0;
        do {
            if ((result = this.textIn.read(content, bytesRead, length - bytesRead)) != -1) continue;
            throw new EOFException("EOF detected before all content read");
        } while ((bytesRead += result) != length);
        return new String(content);
    }
}

