/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.mina.core.buffer;

import org.kaazing.mina.core.buffer.IoBufferEx;

final class IoBufferExHexDumper {
    private static final byte[] highDigits;
    private static final byte[] lowDigits;

    public static String getHexdump(IoBufferEx in, int lengthLimit) {
        if (lengthLimit == 0) {
            throw new IllegalArgumentException("lengthLimit: " + lengthLimit + " (expected: 1+)");
        }
        boolean truncate = in.remaining() > lengthLimit;
        int size = truncate ? lengthLimit : in.remaining();
        if (size == 0) {
            return "empty";
        }
        StringBuilder out = new StringBuilder(size * 3 + 3);
        int pos = in.position();
        int byteValue = in.get(pos++) & 0xFF;
        out.append((char)highDigits[byteValue]);
        out.append((char)lowDigits[byteValue]);
        --size;
        while (size > 0) {
            out.append(' ');
            byteValue = in.get(pos++) & 0xFF;
            out.append((char)highDigits[byteValue]);
            out.append((char)lowDigits[byteValue]);
            --size;
        }
        if (truncate) {
            out.append("...");
        }
        return out.toString();
    }

    private IoBufferExHexDumper() {
    }

    static {
        byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        byte[] high = new byte[256];
        byte[] low = new byte[256];
        for (int i = 0; i < 256; ++i) {
            high[i] = digits[i >>> 4];
            low[i] = digits[i & 0xF];
        }
        highDigits = high;
        lowDigits = low;
    }
}

