/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ChildChannelStateEvent;
import org.jboss.netty.channel.DefaultChannelFuture;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.ChannelGroupFutureListener;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.local.DefaultLocalClientChannelFactory;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.CharsetUtil;
import org.kaazing.robot.driver.RobotException;
import org.kaazing.robot.driver.behavior.Configuration;
import org.kaazing.robot.driver.behavior.PlayBackScript;
import org.kaazing.robot.driver.behavior.RobotCompletionFuture;
import org.kaazing.robot.driver.behavior.RobotCompletionFutureImpl;
import org.kaazing.robot.driver.behavior.handler.CompletionHandler;
import org.kaazing.robot.driver.behavior.parser.Parser;
import org.kaazing.robot.driver.behavior.visitor.GatherStreamsLocationVisitor;
import org.kaazing.robot.driver.behavior.visitor.GenerateConfigurationVisitor;
import org.kaazing.robot.driver.netty.bootstrap.ClientBootstrap;
import org.kaazing.robot.driver.netty.bootstrap.ServerBootstrap;
import org.kaazing.robot.driver.netty.channel.CompositeChannelFuture;
import org.kaazing.robot.lang.LocationInfo;
import org.kaazing.robot.lang.ast.AstNode;
import org.kaazing.robot.lang.ast.AstScriptNode;

public class Robot {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(Robot.class);
    private final List<ChannelFuture> completionFutures = new ArrayList<ChannelFuture>();
    private final List<LocationInfo> progressInfos = new ArrayList<LocationInfo>();
    private final Map<LocationInfo, Object> serverLocations = new HashMap<LocationInfo, Object>();
    private final List<ChannelFuture> bindFutures = new ArrayList<ChannelFuture>();
    private final List<ChannelFuture> connectFutures = new ArrayList<ChannelFuture>();
    private final Channel channel = new DefaultLocalClientChannelFactory().newChannel(Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new SimpleChannelHandler()}));
    private final ChannelFuture startedFuture = Channels.future((Channel)this.channel);
    private final RobotCompletionFutureImpl finishedFuture = new RobotCompletionFutureImpl(this.channel, true);
    private final DefaultChannelGroup serverChannels = new DefaultChannelGroup();
    private final DefaultChannelGroup clientChannels = new DefaultChannelGroup();
    private final Map<LocationInfo, Throwable> failedCauses = new HashMap<LocationInfo, Throwable>();
    private String expectedScript;
    private Configuration configuration;
    private AstScriptNode scriptAST;
    private ChannelFuture preparedFuture;
    private volatile boolean destroyed;

    public Robot() {
        this.listenForFinishedFuture();
    }

    public RobotCompletionFuture getScriptCompleteFuture() {
        return this.finishedFuture;
    }

    public ChannelFuture prepare(String script) throws Exception {
        if (this.preparedFuture != null) {
            throw new IllegalStateException("Script already prepared");
        }
        this.expectedScript = script;
        final boolean debugLogEnabled = LOGGER.isDebugEnabled();
        Parser parser = new Parser();
        this.scriptAST = parser.parse(new ByteArrayInputStream(this.expectedScript.getBytes(CharsetUtil.UTF_8)));
        if (debugLogEnabled) {
            LOGGER.debug("script parsed");
        }
        GenerateConfigurationVisitor visitor = new GenerateConfigurationVisitor();
        this.configuration = (Configuration)this.scriptAST.accept((AstNode.Visitor)visitor, (Object)new GenerateConfigurationVisitor.State());
        if (debugLogEnabled) {
            LOGGER.debug("configuration created");
        }
        this.preparedFuture = this.bindServers();
        for (final CompletionHandler h : this.configuration.getCompletionHandlers()) {
            if (debugLogEnabled) {
                LOGGER.debug("Adding listener for a completion future");
            }
            ChannelFuture f = h.getHandlerFuture();
            this.completionFutures.add(f);
            f.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    Throwable cause;
                    LocationInfo location = h.getProgressInfo();
                    if (debugLogEnabled) {
                        LOGGER.debug("Completion future done. Location info is " + location);
                    }
                    if (location != null) {
                        Robot.this.progressInfos.add(location);
                    }
                    if ((cause = future.getCause()) != null) {
                        if (debugLogEnabled) {
                            LOGGER.error("channel failed with cause: ", cause);
                        } else {
                            LOGGER.error("channel failed with cause: " + cause);
                        }
                        Robot.this.failedCauses.put(h.getStreamStartLocation(), cause);
                    }
                }
            });
        }
        this.listenForScriptCompletion();
        return this.preparedFuture;
    }

    public ChannelFuture prepareAndStart(String script) throws Exception {
        ChannelFuture prepareFuture = this.prepare(script);
        prepareFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                Robot.this.start();
            }
        });
        return this.startedFuture;
    }

    public ChannelFuture start() throws Exception {
        if (this.preparedFuture == null || !this.preparedFuture.isSuccess()) {
            throw new IllegalStateException("Script has not been prepared or is still preparing");
        }
        if (this.startedFuture.isDone()) {
            throw new IllegalStateException("Script has already been started");
        }
        boolean infoLogEnabled = LOGGER.isInfoEnabled();
        for (ClientBootstrap client : this.configuration.getClientBootstraps()) {
            if (infoLogEnabled) {
                LOGGER.debug("Connecting to remote address " + client.getOption("remoteAddress"));
            }
            ChannelFuture connectFuture = client.connect();
            this.connectFutures.add(connectFuture);
            this.clientChannels.add(connectFuture.getChannel());
        }
        if (this.completionFutures.isEmpty() && !this.scriptAST.toString().equals("")) {
            throw new RobotException("No Completion Futures exists");
        }
        this.startedFuture.setSuccess();
        return this.startedFuture;
    }

    public RobotCompletionFuture abort() {
        if (!this.finishedFuture.isDone()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Aborting script");
            }
            this.finishedFuture.cancel();
        }
        return this.finishedFuture;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public boolean destroy() {
        if (this.destroyed) {
            return true;
        }
        this.abort();
        try {
            this.releaseExternalResources();
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Caught exception releasing resources", (Throwable)e);
            }
            return false;
        }
        this.destroyed = true;
        return true;
    }

    private void listenForScriptCompletion() {
        CompositeChannelFuture<ChannelFuture> executionFuture = new CompositeChannelFuture<ChannelFuture>(this.channel, this.completionFutures);
        executionFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                boolean debugLogEnabled = LOGGER.isDebugEnabled();
                String finishedStatus = future.isSuccess() ? "SUCCESS" : "FAILED";
                LOGGER.debug("script completion futures finished with status: " + finishedStatus);
                if (debugLogEnabled) {
                    StringBuilder sb = new StringBuilder();
                    for (LocationInfo progressInfo : Robot.this.progressInfos) {
                        sb.append(progressInfo + ",");
                    }
                    LOGGER.debug("ProgressInfos at script completion: " + sb);
                }
                GatherStreamsLocationVisitor.State state = new GatherStreamsLocationVisitor.State(Robot.this.progressInfos, Robot.this.serverLocations);
                Robot.this.scriptAST.accept((AstNode.Visitor)new GatherStreamsLocationVisitor(), (Object)state);
                PlayBackScript o = new PlayBackScript(Robot.this.expectedScript, state.results, Robot.this.failedCauses);
                String observedScript = o.createPlayBackScript();
                Robot.this.detachAllPipelines();
                for (ChannelFuture f : Robot.this.bindFutures) {
                    f.cancel();
                }
                for (ChannelFuture f : Robot.this.connectFutures) {
                    f.cancel();
                }
                Robot.this.closeChannels();
                if (debugLogEnabled) {
                    LOGGER.debug("Observed:\n" + observedScript);
                }
                if (Robot.this.finishedFuture.isDone()) {
                    Robot.this.finishedFuture.setExpectedScript(Robot.this.expectedScript);
                    Robot.this.finishedFuture.setObservedScript(observedScript);
                } else {
                    Robot.this.finishedFuture.setSuccess(observedScript, Robot.this.expectedScript);
                }
            }
        });
    }

    private void listenForFinishedFuture() {
        this.finishedFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isCancelled()) {
                    if (Robot.this.configuration != null) {
                        for (CompletionHandler h : Robot.this.configuration.getCompletionHandlers()) {
                            ChannelFuture cancelFuture = h.cancel();
                            boolean isDefaultChannelFuture = cancelFuture instanceof DefaultChannelFuture;
                            if (isDefaultChannelFuture) {
                                DefaultChannelFuture.setUseDeadLockChecker((boolean)false);
                            }
                            boolean isCancelled = cancelFuture.awaitUninterruptibly(500L);
                            if (isDefaultChannelFuture) {
                                DefaultChannelFuture.setUseDeadLockChecker((boolean)true);
                            }
                            if (isCancelled) continue;
                            h.getHandlerFuture().setSuccess();
                        }
                    } else {
                        LOGGER.debug("Abort received but script not prepared");
                        Robot.this.finishedFuture.setObservedScript("");
                    }
                }
            }
        });
    }

    private void releaseExternalResources() {
        if (this.configuration != null) {
            for (ServerBootstrap server : this.configuration.getServerBootstraps()) {
                server.releaseExternalResources();
            }
            for (ClientBootstrap client : this.configuration.getClientBootstraps()) {
                client.releaseExternalResources();
            }
        }
    }

    private void detachAllPipelines() {
        SimpleChannelHandler finalHandler = new SimpleChannelHandler(){

            public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
                super.handleDownstream(ctx, e);
            }

            public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
                super.handleUpstream(ctx, e);
            }
        };
        for (ServerBootstrap serverBootstrap : this.configuration.getServerBootstraps()) {
            serverBootstrap.setPipelineFactory(Channels.pipelineFactory((ChannelPipeline)Channels.pipeline((ChannelHandler[])new ChannelHandler[]{finalHandler})));
        }
        for (ClientBootstrap clientBootstrap : this.configuration.getClientBootstraps()) {
            clientBootstrap.setPipelineFactory(Channels.pipelineFactory((ChannelPipeline)Channels.pipeline((ChannelHandler[])new ChannelHandler[]{finalHandler})));
        }
        for (Channel channel : this.clientChannels) {
            ChannelPipeline pipeline = channel.getPipeline();
            for (ChannelHandler handler : pipeline.toMap().values()) {
                pipeline.remove(handler);
            }
            pipeline.addLast("SCRIPTDONEHANDLER", (ChannelHandler)finalHandler);
        }
    }

    private void closeChannels() {
        ChannelGroupFuture closeFuture = this.serverChannels.close();
        closeFuture.addListener(new ChannelGroupFutureListener(){

            public void operationComplete(ChannelGroupFuture future) {
                Robot.this.clientChannels.close();
            }
        });
    }

    private ChannelFuture bindServers() {
        for (final ServerBootstrap server : this.configuration.getServerBootstraps()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Binding to address " + server.getOption("localAddress"));
            }
            LocationInfo location = (LocationInfo)server.getOption("locationInfo");
            assert (!this.serverLocations.containsKey(location)) : "There is already a location " + location + " for this server " + server.getOption("localAddress");
            server.setParentHandler((ChannelHandler)new SimpleChannelHandler(){

                public void childChannelOpen(ChannelHandlerContext ctx, ChildChannelStateEvent e) throws Exception {
                    Robot.this.clientChannels.add(e.getChildChannel());
                }
            });
            ChannelFuture bindFuture = server.bindAsync();
            this.serverChannels.add(bindFuture.getChannel());
            this.bindFutures.add(bindFuture);
            bindFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    boolean isDebugEnabled = LOGGER.isDebugEnabled();
                    if (future.isSuccess()) {
                        if (isDebugEnabled) {
                            LOGGER.debug("Successfully bound to " + server.getOption("localAddress"));
                        }
                        Robot.this.serverLocations.put((LocationInfo)server.getOption("locationInfo"), null);
                    } else {
                        Throwable cause = future.getCause();
                        String errMsg = "Bind to " + server.getOption("localAddress") + " failed.";
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.error(errMsg, cause);
                        } else {
                            LOGGER.error(errMsg + "Due to " + cause);
                        }
                        Collection serverCompletionFutures = (Collection)server.getOption("completionFutures");
                        for (ChannelFuture f : serverCompletionFutures) {
                            f.setFailure(cause);
                        }
                    }
                }
            });
        }
        return Channels.succeededFuture((Channel)this.channel);
    }
}

