/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver;

import java.net.URI;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.kaazing.robot.driver.RobotServer;
import org.kaazing.robot.driver.RobotServerFactory;
import org.kaazing.robot.driver.RobotServerFactorySPI;

public final class RobotServerFactories {
    private RobotServerFactories() {
    }

    public static RobotServerFactory createRobotServerFactory() {
        return RobotServerFactories.createRobotServerFactory(Thread.currentThread().getContextClassLoader());
    }

    public static RobotServerFactory createRobotServerFactory(ClassLoader classLoader) {
        Class<RobotServerFactorySPI> clazz = RobotServerFactorySPI.class;
        ServiceLoader<RobotServerFactorySPI> loader = classLoader != null ? ServiceLoader.load(clazz, classLoader) : ServiceLoader.load(clazz);
        ConcurrentHashMap<String, RobotServerFactorySPI> factories = new ConcurrentHashMap<String, RobotServerFactorySPI>();
        for (RobotServerFactorySPI factory : loader) {
            factories.putIfAbsent(factory.getSchemeName(), factory);
        }
        return new RobotServerFactoryImpl(factories);
    }

    private static class RobotServerFactoryImpl
    implements RobotServerFactory {
        private final Map<String, RobotServerFactorySPI> factories;

        public RobotServerFactoryImpl(Map<String, RobotServerFactorySPI> factories) {
            this.factories = factories;
        }

        @Override
        public RobotServer createRobotServer(URI uri, boolean verbose) {
            String schemeName = uri.getScheme();
            if (schemeName == null) {
                throw new NullPointerException("scheme");
            }
            RobotServerFactorySPI factory = this.factories.get(schemeName);
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Unable to load scheme '%s': No appropriate Robot Server factory found", schemeName));
            }
            return factory.createRobotServer(uri, verbose);
        }
    }
}

