/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ChildChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.handler.logging.LoggingHandler;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.robot.driver.RobotServer;
import org.kaazing.robot.driver.control.handler.ControlDecoder;
import org.kaazing.robot.driver.control.handler.ControlDecoderCompatibility;
import org.kaazing.robot.driver.control.handler.ControlEncoder;
import org.kaazing.robot.driver.control.handler.ControlEncoderCompatibility;
import org.kaazing.robot.driver.control.handler.ControlServerHandler;
import org.kaazing.robot.driver.netty.bootstrap.BootstrapFactory;
import org.kaazing.robot.driver.netty.bootstrap.ServerBootstrap;
import org.kaazing.robot.driver.netty.bootstrap.SingletonBootstrapFactory;
import org.kaazing.robot.driver.netty.channel.ChannelAddress;
import org.kaazing.robot.driver.netty.channel.ChannelAddressFactory;

public class TcpControlledRobotServer
implements RobotServer {
    private final ChannelGroup channelGroup;
    private final List<ControlServerHandler> controlHandlers;
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(TcpControlledRobotServer.class);
    private ServerBootstrap server;
    private final URI acceptURI;
    private Channel serverChannel;
    private final boolean verbose;

    protected TcpControlledRobotServer(URI acceptURI, boolean verbose) {
        this.acceptURI = acceptURI;
        this.verbose = verbose;
        this.channelGroup = new DefaultChannelGroup("robot-server");
        this.controlHandlers = new CopyOnWriteArrayList<ControlServerHandler>();
    }

    @Override
    public void start() throws Exception {
        if (this.acceptURI == null) {
            throw new NullPointerException("acceptURI");
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        ChannelAddressFactory addressFactory = ChannelAddressFactory.newChannelAddressFactory();
        ChannelAddress localAddress = addressFactory.newChannelAddress(this.acceptURI, options);
        BootstrapFactory factory = SingletonBootstrapFactory.getInstance();
        this.server = factory.newServerBootstrap(this.acceptURI.getScheme());
        this.server.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                ControlDecoder decoder = new ControlDecoder();
                pipeline.addLast("control.decoder", (ChannelHandler)decoder);
                ControlDecoderCompatibility decoderCompatibility = new ControlDecoderCompatibility();
                pipeline.addLast("control.decoder.compatibility", (ChannelHandler)decoderCompatibility);
                ControlEncoder encoder = new ControlEncoder();
                pipeline.addLast("control.encoder", (ChannelHandler)encoder);
                ControlEncoderCompatibility encoderCompatibility = new ControlEncoderCompatibility();
                pipeline.addLast("control.encoder.compatibility", (ChannelHandler)encoderCompatibility);
                if (TcpControlledRobotServer.this.verbose) {
                    LoggingHandler logging = new LoggingHandler("robot.server", false);
                    pipeline.addLast("control.logging", (ChannelHandler)logging);
                }
                ControlServerHandler controller = new ControlServerHandler();
                pipeline.addLast("control.handler", (ChannelHandler)controller);
                return pipeline;
            }
        });
        this.server.setParentHandler((ChannelHandler)new SimpleChannelHandler(){

            public void childChannelOpen(ChannelHandlerContext ctx, ChildChannelStateEvent e) throws Exception {
                LOGGER.debug("Control Channel Opened");
                Channel childChannel = e.getChildChannel();
                TcpControlledRobotServer.this.channelGroup.add((Object)childChannel);
                final ControlServerHandler controller = (ControlServerHandler)childChannel.getPipeline().getContext("control.handler").getHandler();
                TcpControlledRobotServer.this.controlHandlers.add(controller);
                controller.getChannelClosedFuture().addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        TcpControlledRobotServer.this.controlHandlers.remove((Object)controller);
                    }
                });
            }
        });
        this.serverChannel = this.server.bind(localAddress);
    }

    @Override
    public void stop() throws TimeoutException {
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        if (this.serverChannel != null) {
            this.serverChannel.close().awaitUninterruptibly(2000L);
            if (isDebugEnabled) {
                LOGGER.debug("Server control channel closed.");
            }
        }
        this.channelGroup.close().awaitUninterruptibly(2000L);
        if (isDebugEnabled) {
            LOGGER.debug("Control channels closed.");
        }
        for (ControlServerHandler controller : this.controlHandlers) {
            controller.getChannelClosedFuture().awaitUninterruptibly(2000L);
        }
        if (this.server != null) {
            LOGGER.debug("Releasing external resources");
            this.server.releaseExternalResources();
            if (isDebugEnabled) {
                LOGGER.debug("External resources released.");
            }
        }
    }

    @Override
    public void join() throws InterruptedException {
        if (this.serverChannel != null) {
            this.serverChannel.getCloseFuture().await();
        }
    }
}

