/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.kaazing.robot.driver.behavior.handler.LogLastEventHandler;
import org.kaazing.robot.driver.behavior.visitor.GatherStreamsLocationVisitor;
import org.kaazing.robot.lang.LocationInfo;

public class PlayBackScript {
    public static final char COMMENT = '#';
    private final String startScript;
    private State my_state;
    private boolean inComment;
    private int atLine;
    private int lastColumnAt;
    private final Iterator<GatherStreamsLocationVisitor.StreamResultLocationInfo> currentLocationIterator;
    private final Map<LocationInfo, Throwable> failedLocations;

    public PlayBackScript(String startScript, Iterable<GatherStreamsLocationVisitor.StreamResultLocationInfo> results) {
        this(startScript, results, new HashMap<LocationInfo, Throwable>(0, 100.0f));
    }

    public PlayBackScript(String startScript, Iterable<GatherStreamsLocationVisitor.StreamResultLocationInfo> results, Map<LocationInfo, Throwable> failedLocations) {
        this.startScript = startScript;
        this.failedLocations = failedLocations;
        this.atLine = 0;
        this.currentLocationIterator = results.iterator();
        this.lastColumnAt = -1;
        this.setInComment(false);
        if (!this.currentLocationIterator.hasNext()) {
            this.setState(new FinishState(this.startScript, true));
        } else {
            GatherStreamsLocationVisitor.StreamResultLocationInfo currentLocation = this.currentLocationIterator.next();
            this.setState(new BlankState(this.startScript, currentLocation, currentLocation.start));
        }
    }

    public String createPlayBackScript() {
        StringBuilder result = new StringBuilder();
        while (!(this.my_state instanceof FinishState)) {
            result.append(this.my_state.transition());
        }
        return result.append(this.my_state.transition()).toString();
    }

    private void setState(State s) {
        this.my_state = s;
    }

    private boolean isInComment() {
        return this.inComment;
    }

    private void setInComment(boolean val) {
        this.inComment = val;
    }

    private final class FinishState
    extends AbstractState {
        private boolean skipAll;

        public FinishState() {
            super(null, null, null);
        }

        public FinishState(String script) {
            super(script, null, null);
        }

        public FinishState(String script, boolean skipAll) {
            this(script);
            this.skipAll = skipAll;
        }

        public FinishState(boolean skipAll) {
            super(null, null, null);
            this.skipAll = skipAll;
        }

        @Override
        protected boolean wantAppend(char c) {
            return !this.skipAll && (PlayBackScript.this.isInComment() || Character.isWhitespace(c));
        }

        @Override
        protected AbstractState transitionIfNeeded() {
            throw new RuntimeException("Invalid method call. transitionIfNeeded should not be called");
        }

        @Override
        public String transition() {
            if (this.originalScriptFragment == null || this.originalScriptFragment.equals("")) {
                return "";
            }
            int strLen = this.originalScriptFragment.length();
            boolean seenNonCommentLine = false;
            for (int currentIndex = 0; currentIndex < strLen; ++currentIndex) {
                char c = this.originalScriptFragment.charAt(currentIndex);
                PlayBackScript.this.lastColumnAt++;
                if (c == '\n') {
                    PlayBackScript.this.atLine++;
                    PlayBackScript.this.lastColumnAt = -1;
                    if (!seenNonCommentLine && !PlayBackScript.this.isInComment()) {
                        seenNonCommentLine = true;
                        if (this.deviatedStreamStartLoc != null) {
                            String lastEvent;
                            Throwable failure = (Throwable)PlayBackScript.this.failedLocations.get(this.deviatedStreamStartLoc);
                            if (failure != null && (lastEvent = LogLastEventHandler.getLastEvent(this.deviatedStreamStartLoc)) != null) {
                                this.observedStream.append(lastEvent + "\n");
                            }
                            this.deviatedStreamStartLoc = null;
                        }
                    }
                    PlayBackScript.this.setInComment(false);
                } else if (c == '#') {
                    PlayBackScript.this.setInComment(true);
                }
                this.appendIfWanted(c);
            }
            return this.observedStream.toString();
        }
    }

    private final class SkipScriptState
    extends AbstractState {
        private boolean appendAll;
        private StringBuilder skipedCharsOnLine;

        public SkipScriptState(String original, GatherStreamsLocationVisitor.StreamResultLocationInfo loc, LocationInfo changeStateInfo) {
            super(original, loc, changeStateInfo);
            this.skipedCharsOnLine = new StringBuilder();
        }

        @Override
        protected boolean wantAppend(char c) {
            return this.appendAll || this.deviatedStreamStartLoc != null && (PlayBackScript.this.isInComment() || this.lineJustWhiteSpace && Character.isWhitespace(c));
        }

        @Override
        protected boolean appendIfWanted(char c) {
            boolean appended = super.appendIfWanted(c);
            if (!appended) {
                this.skipedCharsOnLine.append(c);
            }
            if (c == '\n') {
                this.skipedCharsOnLine = new StringBuilder();
            }
            return appended;
        }

        @Override
        protected AbstractState transitionIfNeeded() {
            LocationInfo currentLoc = new LocationInfo(PlayBackScript.this.atLine + 1, PlayBackScript.this.lastColumnAt);
            AbstractState newState = null;
            if (this.lookingForLocation.equals((Object)currentLoc)) {
                this.switchStates = true;
                if (PlayBackScript.this.lastColumnAt == 0) {
                    this.observedStream.append((CharSequence)this.skipedCharsOnLine);
                }
                this.skipedCharsOnLine = new StringBuilder();
                if (this.lookingForLocation.equals((Object)this.currentStream.start)) {
                    this.appendAll = true;
                    if (this.currentStream.observed != null && !this.currentStream.observed.equals((Object)this.currentStream.start)) {
                        newState = new CopyScriptState(null, this.currentStream, this.currentStream.observed);
                    } else if (PlayBackScript.this.currentLocationIterator.hasNext()) {
                        this.currentStream = (GatherStreamsLocationVisitor.StreamResultLocationInfo)PlayBackScript.this.currentLocationIterator.next();
                        newState = new BlankState(null, this.currentStream, this.currentStream.start);
                    } else {
                        newState = new FinishState(true);
                    }
                } else if (this.lookingForLocation.equals((Object)this.currentStream.end)) {
                    this.switchStates = true;
                    this.appendAll = false;
                    if (PlayBackScript.this.currentLocationIterator.hasNext()) {
                        this.currentStream = (GatherStreamsLocationVisitor.StreamResultLocationInfo)PlayBackScript.this.currentLocationIterator.next();
                        newState = new BlankState(null, this.currentStream, this.currentStream.start);
                    } else {
                        newState = new FinishState();
                    }
                } else assert (false) : "Invalid state. Can not skip up to observed location.";
            } else assert (currentLoc.compareTo(this.lookingForLocation) < 0) : String.format("Current location |%s| greater than changeStateInfo |%s|", currentLoc, this.lookingForLocation);
            return newState;
        }
    }

    private final class CopyScriptState
    extends AbstractState {
        public CopyScriptState(String originalScript, GatherStreamsLocationVisitor.StreamResultLocationInfo loc, LocationInfo changeStateInfo) {
            super(originalScript, loc, changeStateInfo);
        }

        @Override
        protected AbstractState transitionIfNeeded() {
            AbstractState newState = null;
            LocationInfo currentLoc = new LocationInfo(PlayBackScript.this.atLine + 1, PlayBackScript.this.lastColumnAt);
            if (this.lookingForLocation.equals((Object)currentLoc)) {
                if (this.currentStream.observed.equals((Object)this.currentStream.end)) {
                    this.switchStates = true;
                    if (PlayBackScript.this.currentLocationIterator.hasNext()) {
                        this.currentStream = (GatherStreamsLocationVisitor.StreamResultLocationInfo)PlayBackScript.this.currentLocationIterator.next();
                        newState = new BlankState(null, this.currentStream, this.currentStream.start);
                    } else {
                        newState = new FinishState();
                    }
                } else {
                    this.switchStates = true;
                    newState = new SkipScriptState(null, this.currentStream, this.currentStream.end);
                    newState.deviatedStreamStartLoc = this.currentStream.start;
                }
            } else assert (currentLoc.compareTo(this.lookingForLocation) < 0) : String.format("Current location %s is greater than changeStateInfo %s,", currentLoc, this.lookingForLocation);
            return newState;
        }
    }

    private final class BlankState
    extends AbstractState {
        private boolean appendAll;
        private StringBuilder skipedCharsOnLine;

        public BlankState(String originalScript, GatherStreamsLocationVisitor.StreamResultLocationInfo loc, LocationInfo changeStateInfo) {
            super(originalScript, loc, changeStateInfo);
            this.skipedCharsOnLine = new StringBuilder();
        }

        @Override
        protected boolean wantAppend(char c) {
            return this.appendAll || !this.switchStates && (PlayBackScript.this.isInComment() || Character.isWhitespace(c));
        }

        @Override
        protected boolean appendIfWanted(char c) {
            boolean appended = super.appendIfWanted(c);
            if (!appended) {
                this.skipedCharsOnLine.append(c);
            }
            if (c == '\n') {
                this.skipedCharsOnLine = new StringBuilder();
            }
            return appended;
        }

        @Override
        protected AbstractState transitionIfNeeded() {
            AbstractState newState = null;
            LocationInfo currentLoc = new LocationInfo(PlayBackScript.this.atLine + 1, PlayBackScript.this.lastColumnAt);
            this.switchStates = true;
            if (this.lookingForLocation.equals((Object)currentLoc)) {
                this.appendAll = true;
                if (PlayBackScript.this.lastColumnAt == 0) {
                    this.observedStream.append((CharSequence)this.skipedCharsOnLine);
                }
                this.skipedCharsOnLine = new StringBuilder();
                if (this.currentStream.observed != null && !this.currentStream.observed.equals((Object)currentLoc)) {
                    newState = new CopyScriptState(null, this.currentStream, this.currentStream.observed);
                } else {
                    LocationInfo deviate = null;
                    if (this.currentStream.observed != null) {
                        deviate = this.currentStream.start;
                    }
                    if (PlayBackScript.this.currentLocationIterator.hasNext()) {
                        this.currentStream = (GatherStreamsLocationVisitor.StreamResultLocationInfo)PlayBackScript.this.currentLocationIterator.next();
                        newState = new BlankState(null, this.currentStream, this.currentStream.start);
                    } else {
                        newState = new FinishState(true);
                    }
                    if (deviate != null) {
                        newState.deviatedStreamStartLoc = deviate;
                    }
                }
            } else {
                assert (currentLoc.compareTo(this.lookingForLocation) < 0) : String.format("Current location %s is greater than changeStateInfo %s,", currentLoc, this.lookingForLocation);
                this.appendAll = false;
                newState = new SkipScriptState(null, this.currentStream, this.lookingForLocation);
            }
            return newState;
        }
    }

    private abstract class AbstractState
    implements State {
        protected String originalScriptFragment;
        protected final StringBuilder observedStream = new StringBuilder();
        protected LocationInfo lookingForLocation;
        protected GatherStreamsLocationVisitor.StreamResultLocationInfo currentStream;
        protected LocationInfo deviatedStreamStartLoc;
        protected boolean switchStates;
        protected boolean lineJustWhiteSpace;

        public AbstractState(String originalScript, GatherStreamsLocationVisitor.StreamResultLocationInfo loc, LocationInfo changeStateInfo) {
            this.originalScriptFragment = originalScript;
            this.lookingForLocation = changeStateInfo;
            this.currentStream = loc;
        }

        public void setOriginalScript(String s) {
            this.originalScriptFragment = s;
        }

        protected abstract AbstractState transitionIfNeeded();

        protected boolean wantAppend(char c) {
            return true;
        }

        protected boolean appendIfWanted(char c) {
            if (this.wantAppend(c)) {
                this.observedStream.append(c);
                return true;
            }
            return false;
        }

        @Override
        public String transition() {
            assert (this.originalScriptFragment != null) : "NullPointer. originalScript not set";
            int strLen = this.originalScriptFragment.length();
            AbstractState newState = null;
            this.lineJustWhiteSpace = true;
            for (int currentIndex = 0; currentIndex < strLen; ++currentIndex) {
                PlayBackScript.this.lastColumnAt++;
                char c = this.originalScriptFragment.charAt(currentIndex);
                if (c == '\n') {
                    PlayBackScript.this.atLine++;
                    PlayBackScript.this.lastColumnAt = -1;
                    if (this.deviatedStreamStartLoc != null && !PlayBackScript.this.isInComment() && !this.lineJustWhiteSpace) {
                        String lastEvent;
                        Throwable failure = (Throwable)PlayBackScript.this.failedLocations.get(this.deviatedStreamStartLoc);
                        if (failure != null && (lastEvent = LogLastEventHandler.getLastEvent(this.deviatedStreamStartLoc)) != null) {
                            this.observedStream.append(lastEvent + "\n");
                        }
                        this.deviatedStreamStartLoc = null;
                    }
                    this.appendIfWanted(c);
                    PlayBackScript.this.setInComment(false);
                    if (newState != null) {
                        newState.setOriginalScript(++currentIndex < strLen ? this.originalScriptFragment.substring(currentIndex) : null);
                        PlayBackScript.this.setState(newState);
                        return this.observedStream.toString();
                    }
                    this.lineJustWhiteSpace = true;
                    continue;
                }
                if (!PlayBackScript.this.isInComment()) {
                    if (c == '#') {
                        this.lineJustWhiteSpace = false;
                        PlayBackScript.this.setInComment(true);
                    } else if (!Character.isWhitespace(c)) {
                        this.lineJustWhiteSpace = false;
                        if (newState == null) {
                            newState = this.transitionIfNeeded();
                        }
                    }
                    this.appendIfWanted(c);
                    continue;
                }
                this.appendIfWanted(c);
            }
            assert (newState == null || newState instanceof FinishState) : "End of input script before last end location";
            PlayBackScript.this.setState(new FinishState());
            return this.observedStream.toString();
        }
    }

    private static interface State {
        public String transition();
    }
}

