/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler;

import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.robot.driver.behavior.handler.ExecutionHandler;
import org.kaazing.robot.driver.behavior.handler.LogLastEventHandler;
import org.kaazing.robot.driver.behavior.handler.prepare.DownstreamPreparationEvent;
import org.kaazing.robot.driver.behavior.handler.prepare.PreparationEvent;
import org.kaazing.robot.driver.netty.channel.ChannelFutureListeners;
import org.kaazing.robot.lang.LocationInfo;

public class CompletionHandler
extends ExecutionHandler {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(CompletionHandler.class);
    private LocationInfo progressInfo;

    public LocationInfo getProgressInfo() {
        return this.progressInfo;
    }

    @Override
    public void prepareRequested(final ChannelHandlerContext ctx, final PreparationEvent evt) {
        super.prepareRequested(ctx, evt);
        ChannelFuture pipelineFuture = this.getPipelineFuture();
        ChannelFuture handlerFuture = this.getHandlerFuture();
        pipelineFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                CompletionHandler.this.progressInfo = evt.getProgressInfo();
                if (CompletionHandler.this.progressInfo == null) {
                    CompletionHandler.this.progressInfo = CompletionHandler.this.getStreamStartLocation();
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("pipeline handler complete. Location info is " + CompletionHandler.this.progressInfo);
                }
                ((LogLastEventHandler)ctx.getPipeline().get(LogLastEventHandler.class)).setDone();
            }
        });
        pipelineFuture.addListener(ChannelFutureListeners.chainedFuture(handlerFuture));
        ChannelFuture prepareFuture = evt.getFuture();
        prepareFuture.setSuccess();
        Channel channel = evt.getChannel();
        ctx.sendDownstream((ChannelEvent)new DownstreamPreparationEvent(channel, Channels.succeededFuture((Channel)channel)));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        LOGGER.error("Unexpected handled exception ", e.getCause());
    }
}

