/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.LifeCycleAwareChannelHandler;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.robot.driver.behavior.handler.barrier.AwaitBarrierDownstreamHandler;
import org.kaazing.robot.driver.behavior.handler.prepare.PreparationEvent;
import org.kaazing.robot.driver.behavior.handler.prepare.SimplePrepareUpstreamHandler;
import org.kaazing.robot.driver.channel.Channels;
import org.kaazing.robot.lang.LocationInfo;

public class ExecutionHandler
extends SimplePrepareUpstreamHandler
implements LifeCycleAwareChannelHandler {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(AwaitBarrierDownstreamHandler.class);
    private ChannelFuture handlerFuture;
    private ChannelFuture pipelineFuture;
    private ChannelFuture cancelFuture;
    private LocationInfo locationInfo;
    private LocationInfo streamStartLocation;
    private final AtomicBoolean preparationLatch = new AtomicBoolean();
    private Channel channel;

    public ChannelFuture cancel() {
        if (this.pipelineFuture != null) {
            this.pipelineFuture.setSuccess();
            this.cancelFuture = org.jboss.netty.channel.Channels.succeededFuture((Channel)this.pipelineFuture.getChannel());
        } else {
            this.cancelFuture = org.jboss.netty.channel.Channels.future(null);
        }
        return this.cancelFuture;
    }

    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    public void setLocationInfo(LocationInfo locationInfo) {
        this.locationInfo = locationInfo;
    }

    public LocationInfo getStreamStartLocation() {
        return this.streamStartLocation;
    }

    public void setStreamStartLocation(LocationInfo streamStart) {
        this.streamStartLocation = streamStart;
    }

    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public void prepareRequested(ChannelHandlerContext ctx, PreparationEvent evt) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("preparation request received in execution handler for " + (Object)((Object)this));
        }
        this.channel = ctx.getChannel();
        this.preparationLatch.set(true);
        this.pipelineFuture = evt.checkpoint(this.locationInfo, this.handlerFuture);
        if (this.cancelFuture != null) {
            this.pipelineFuture.setSuccess();
            this.cancelFuture.setSuccess();
        }
        super.prepareRequested(ctx, evt);
    }

    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        assert (this.handlerFuture == null);
        this.handlerFuture = org.jboss.netty.channel.Channels.future((Channel)ctx.getChannel());
    }

    public void afterAdd(ChannelHandlerContext ctx) throws Exception {
        assert (this.handlerFuture != null);
    }

    public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
        assert (this.handlerFuture != null);
    }

    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
        assert (this.handlerFuture != null);
        if (!this.handlerFuture.isDone()) {
            this.handlerFuture.setFailure(new IllegalStateException("ChannelHandler removed before completion").fillInStackTrace());
        }
        this.handlerFuture = null;
    }

    public ChannelFuture getHandlerFuture() {
        if (this.handlerFuture == null) {
            throw new IllegalStateException("ChannelHandler not added to pipeline yet");
        }
        return this.handlerFuture;
    }

    public ChannelFuture getPipelineFuture() {
        if (this.pipelineFuture == null) {
            throw new IllegalStateException("ChannelHandler not prepared yet");
        }
        return this.pipelineFuture;
    }

    @Override
    protected final void handleUpstream0(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (this.preparationLatch.compareAndSet(false, true)) {
            Channels.prepare(ctx.getChannel());
        }
        this.handleUpstream1(ctx, e);
    }

    protected void handleUpstream1(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        super.handleUpstream0(ctx, e);
    }
}

