/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler;

import java.util.concurrent.ConcurrentHashMap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.kaazing.robot.lang.LocationInfo;

public class LogLastEventHandler
extends SimpleChannelHandler {
    private static final ConcurrentHashMap<LocationInfo, String> EVENTS;
    private final LocationInfo streamLocStart;
    private boolean isDone;
    private static final String NEWLINE;
    private static final String[] BYTE2HEX;
    private static final String[] HEXPADDING;
    private static final String[] BYTEPADDING;
    private static final char[] BYTE2CHAR;

    public static String getLastEvent(LocationInfo startLocForStream) {
        return EVENTS.get(startLocForStream);
    }

    public void setDone() {
        this.isDone = true;
    }

    public LogLastEventHandler(LocationInfo location) {
        this.streamLocStart = location;
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (!this.isDone) {
            if (e instanceof ExceptionEvent) {
                this.setDone();
            }
            EVENTS.put(this.streamLocStart, LogLastEventHandler.eventToString(e));
        }
        super.handleUpstream(ctx, e);
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (!this.isDone) {
            EVENTS.put(this.streamLocStart, LogLastEventHandler.eventToString(e));
        }
        super.handleDownstream(ctx, e);
    }

    public static void clear() {
        EVENTS.clear();
    }

    private static String eventToString(ChannelEvent e) {
        MessageEvent me;
        String msg = e.toString();
        if (e instanceof MessageEvent && (me = (MessageEvent)e).getMessage() instanceof ChannelBuffer) {
            msg = msg + LogLastEventHandler.formatBuffer((ChannelBuffer)me.getMessage());
        }
        return msg;
    }

    private static String formatBuffer(ChannelBuffer buf) {
        int i;
        int length = buf.readableBytes();
        int rows = length / 16 + (length % 15 == 0 ? 0 : 1) + 4;
        StringBuilder dump = new StringBuilder(rows * 80);
        dump.append(NEWLINE + "         +-------------------------------------------------+" + NEWLINE + "         |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |" + NEWLINE + "+--------+-------------------------------------------------+----------------+");
        int startIndex = buf.readerIndex();
        int endIndex = buf.writerIndex();
        for (i = startIndex; i < endIndex; ++i) {
            int relIdx = i - startIndex;
            int relIdxMod16 = relIdx & 0xF;
            if (relIdxMod16 == 0) {
                dump.append(NEWLINE);
                dump.append(Long.toHexString((long)relIdx & 0xFFFFFFFFL | 0x100000000L));
                dump.setCharAt(dump.length() - 9, '|');
                dump.append('|');
            }
            dump.append(BYTE2HEX[buf.getUnsignedByte(i)]);
            if (relIdxMod16 != 15) continue;
            dump.append(" |");
            for (int j = i - 15; j <= i; ++j) {
                dump.append(BYTE2CHAR[buf.getUnsignedByte(j)]);
            }
            dump.append('|');
        }
        if ((i - startIndex & 0xF) != 0) {
            int remainder = length & 0xF;
            dump.append(HEXPADDING[remainder]);
            dump.append(" |");
            for (int j = i - remainder; j < i; ++j) {
                dump.append(BYTE2CHAR[buf.getUnsignedByte(j)]);
            }
            dump.append(BYTEPADDING[remainder]);
            dump.append('|');
        }
        dump.append(NEWLINE + "+--------+-------------------------------------------------+----------------+");
        return dump.toString();
    }

    static {
        int j;
        StringBuilder buf;
        StringBuilder buf2;
        int i;
        EVENTS = new ConcurrentHashMap();
        NEWLINE = String.format("%n", new Object[0]);
        BYTE2HEX = new String[256];
        HEXPADDING = new String[16];
        BYTEPADDING = new String[16];
        BYTE2CHAR = new char[256];
        for (i = 0; i < 10; ++i) {
            buf2 = new StringBuilder(3);
            buf2.append(" 0");
            buf2.append(i);
            LogLastEventHandler.BYTE2HEX[i] = buf2.toString();
        }
        while (i < 16) {
            buf2 = new StringBuilder(3);
            buf2.append(" 0");
            buf2.append((char)(97 + i - 10));
            LogLastEventHandler.BYTE2HEX[i] = buf2.toString();
            ++i;
        }
        while (i < BYTE2HEX.length) {
            buf2 = new StringBuilder(3);
            buf2.append(' ');
            buf2.append(Integer.toHexString(i));
            LogLastEventHandler.BYTE2HEX[i] = buf2.toString();
            ++i;
        }
        for (i = 0; i < HEXPADDING.length; ++i) {
            int padding = HEXPADDING.length - i;
            buf = new StringBuilder(padding * 3);
            for (j = 0; j < padding; ++j) {
                buf.append("   ");
            }
            LogLastEventHandler.HEXPADDING[i] = buf.toString();
        }
        for (i = 0; i < BYTEPADDING.length; ++i) {
            int padding = BYTEPADDING.length - i;
            buf = new StringBuilder(padding);
            for (j = 0; j < padding; ++j) {
                buf.append(' ');
            }
            LogLastEventHandler.BYTEPADDING[i] = buf.toString();
        }
        for (i = 0; i < BYTE2CHAR.length; ++i) {
            LogLastEventHandler.BYTE2CHAR[i] = i <= 31 || i >= 127 ? 46 : (char)i;
        }
    }
}

