/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.barrier;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.robot.driver.behavior.Barrier;
import org.kaazing.robot.driver.behavior.handler.barrier.AbstractBarrierHandler;
import org.kaazing.robot.driver.behavior.handler.prepare.PreparationEvent;
import org.kaazing.robot.driver.netty.channel.ChannelFutureListeners;

public class AwaitBarrierDownstreamHandler
extends AbstractBarrierHandler
implements ChannelDownstreamHandler {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(AwaitBarrierDownstreamHandler.class);
    private Queue<ChannelEvent> queue;

    public AwaitBarrierDownstreamHandler(Barrier barrier) {
        super(barrier);
    }

    @Override
    public void prepareRequested(final ChannelHandlerContext ctx, PreparationEvent evt) {
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        if (isDebugEnabled) {
            LOGGER.debug("await barrier downstream prepare received");
        }
        super.prepareRequested(ctx, evt);
        if (isDebugEnabled) {
            LOGGER.debug("await barrier downstream prepare on super returned");
        }
        final ChannelFuture handlerFuture = this.getHandlerFuture();
        ChannelFuture pipelineFuture = this.getPipelineFuture();
        pipelineFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture f) throws Exception {
                LOGGER.debug("pipeline future for downstream barrier complete");
                if (!f.isSuccess()) {
                    if (f.isCancelled()) {
                        handlerFuture.cancel();
                    } else {
                        handlerFuture.setFailure(f.getCause());
                    }
                } else {
                    Barrier barrier = AwaitBarrierDownstreamHandler.this.getBarrier();
                    ChannelFuture barrierFuture = barrier.getFuture();
                    barrierFuture.addListener(ChannelFutureListeners.chainedFuture(handlerFuture));
                }
            }
        });
        this.queue = new ConcurrentLinkedQueue<ChannelEvent>();
        handlerFuture.addListener(new ChannelFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    ChannelHandlerContext channelHandlerContext = ctx;
                    synchronized (channelHandlerContext) {
                        LOGGER.debug("Barrier has been notified. Releasing queued downstream events");
                        Queue pending = AwaitBarrierDownstreamHandler.this.queue;
                        AwaitBarrierDownstreamHandler.this.queue = null;
                        for (ChannelEvent evt : pending) {
                            ctx.sendDownstream(evt);
                        }
                    }
                } else {
                    LOGGER.debug("handler future for downstream barrier failed - not releasing downstream events");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        if (this.queue == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("downstream barrier not finished preparing sending event " + evt + " upstream");
            }
        } else if (!this.getPipelineFuture().isDone()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("downstream barrier pipeline not finished sending event " + evt + " upstream");
            }
        } else {
            if (!this.getHandlerFuture().isDone()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Awaiting on barrier notification. Queueing downstream event " + evt);
                }
                this.queue.add(evt);
                return;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("barrier future is done sending event " + evt + " upstream");
            }
        }
        ChannelHandlerContext channelHandlerContext = ctx;
        synchronized (channelHandlerContext) {
            ctx.sendDownstream(evt);
        }
    }

    boolean hasQueuedChannelEvents() {
        return this.queue != null && !this.queue.isEmpty();
    }
}

