/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.barrier;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.robot.driver.behavior.Barrier;
import org.kaazing.robot.driver.behavior.handler.barrier.AbstractBarrierHandler;
import org.kaazing.robot.driver.behavior.handler.prepare.PreparationEvent;
import org.kaazing.robot.driver.netty.channel.ChannelFutureListeners;

public class AwaitBarrierUpstreamHandler
extends AbstractBarrierHandler
implements ChannelUpstreamHandler {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(AwaitBarrierUpstreamHandler.class);
    private Queue<ChannelEvent> queue;

    public AwaitBarrierUpstreamHandler(Barrier barrier) {
        super(barrier);
    }

    @Override
    public void prepareRequested(final ChannelHandlerContext ctx, PreparationEvent evt) {
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        if (isDebugEnabled) {
            LOGGER.debug("await barrier upstream prepare received");
        }
        super.prepareRequested(ctx, evt);
        if (isDebugEnabled) {
            LOGGER.debug("await barrier upstream prepare on super returned");
        }
        final ChannelFuture handlerFuture = this.getHandlerFuture();
        ChannelFuture pipelineFuture = this.getPipelineFuture();
        pipelineFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture f) throws Exception {
                LOGGER.debug("pipeline future for upstream barrier complete");
                if (!f.isSuccess()) {
                    if (f.isCancelled()) {
                        handlerFuture.cancel();
                    } else {
                        handlerFuture.setFailure(f.getCause());
                    }
                } else {
                    Barrier barrier = AwaitBarrierUpstreamHandler.this.getBarrier();
                    ChannelFuture barrierFuture = barrier.getFuture();
                    barrierFuture.addListener(ChannelFutureListeners.chainedFuture(handlerFuture));
                }
            }
        });
        this.queue = new ConcurrentLinkedQueue<ChannelEvent>();
        handlerFuture.addListener(new ChannelFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    ChannelHandlerContext channelHandlerContext = ctx;
                    synchronized (channelHandlerContext) {
                        LOGGER.debug("Barrier has been notified. Releasing queued upstream events");
                        Queue pending = AwaitBarrierUpstreamHandler.this.queue;
                        AwaitBarrierUpstreamHandler.this.queue = null;
                        for (ChannelEvent evt : pending) {
                            ctx.sendUpstream(evt);
                        }
                    }
                } else {
                    LOGGER.debug("handler future for barrier completed unsuccessfully. Not releaseing upstream events");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleUpstream1(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        if (!this.getPipelineFuture().isDone()) {
            LOGGER.warn("Received upstream event " + evt + " in barrier before pipeline future is complete");
        }
        ChannelFuture handlerFuture = this.getHandlerFuture();
        ChannelHandlerContext channelHandlerContext = ctx;
        synchronized (channelHandlerContext) {
            if (!handlerFuture.isDone()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Awaiting on barrier notification. Queueing upstream event " + evt);
                }
                this.queue.add(evt);
                return;
            }
            ctx.sendUpstream(evt);
        }
    }

    boolean hasQueuedChannelEvents() {
        return this.queue != null && !this.queue.isEmpty();
    }
}

