/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.barrier;

import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.robot.driver.behavior.Barrier;
import org.kaazing.robot.driver.behavior.handler.barrier.AbstractBarrierHandler;
import org.kaazing.robot.driver.behavior.handler.prepare.PreparationEvent;
import org.kaazing.robot.driver.netty.channel.ChannelFutureListeners;

public class NotifyBarrierHandler
extends AbstractBarrierHandler {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(NotifyBarrierHandler.class);

    public NotifyBarrierHandler(Barrier barrier) {
        super(barrier);
    }

    @Override
    public void prepareRequested(ChannelHandlerContext ctx, PreparationEvent evt) {
        super.prepareRequested(ctx, evt);
        Barrier barrier = this.getBarrier();
        final ChannelFuture barrierFuture = barrier.getFuture();
        ChannelFuture pipelineFuture = this.getPipelineFuture();
        ChannelFuture handlerFuture = this.getHandlerFuture();
        if (LOGGER.isInfoEnabled()) {
            pipelineFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture f) throws Exception {
                    if (f.isSuccess()) {
                        LOGGER.debug("Notifying barrier");
                        barrierFuture.setSuccess();
                    }
                }
            });
        }
        pipelineFuture.addListener(ChannelFutureListeners.chainedFuture(handlerFuture));
    }
}

