/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.codec;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.DefaultHttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.kaazing.robot.driver.behavior.handler.codec.HttpUtils;
import org.kaazing.robot.driver.behavior.handler.codec.SimpleHttpChannelDownstreamHandler;

public class HttpMessageAggregatingCodec
extends SimpleHttpChannelDownstreamHandler {
    HttpMessage aggregatedHttpMessage;

    @Override
    public void writeHttpRequest(ChannelHandlerContext ctx, MessageEvent e, HttpRequest httpRequest) throws Exception {
        if (httpRequest.isChunked()) {
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture(), (Object)httpRequest);
        } else {
            this.aggregatedHttpMessage = httpRequest;
        }
    }

    @Override
    public void writeHttpResponse(ChannelHandlerContext ctx, MessageEvent e, HttpResponse httpResponse) throws Exception {
        if (httpResponse.isChunked()) {
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture(), (Object)httpResponse);
            HttpUtils.removeHttpFiltersFromPipeline(ctx.getPipeline());
        } else {
            this.aggregatedHttpMessage = httpResponse;
        }
    }

    @Override
    public void writeHttpChunk(ChannelHandlerContext ctx, MessageEvent e, HttpChunk chunk) throws Exception {
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture(), (Object)chunk);
    }

    @Override
    public void writeHttpContent(ChannelHandlerContext ctx, MessageEvent e, ChannelBuffer httpContent) throws Exception {
        if (this.aggregatedHttpMessage.isChunked()) {
            DefaultHttpChunk chunk = new DefaultHttpChunk(httpContent);
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture(), (Object)chunk);
        } else {
            ChannelBuffer priorContent = this.aggregatedHttpMessage.getContent();
            if (priorContent == null || priorContent == ChannelBuffers.EMPTY_BUFFER) {
                this.aggregatedHttpMessage.setContent(httpContent);
            } else {
                ChannelBuffer[] holdingBuffer = new ChannelBuffer[]{priorContent, httpContent};
                this.aggregatedHttpMessage.setContent(ChannelBuffers.wrappedBuffer((ChannelBuffer[])holdingBuffer));
            }
            e.getFuture().setSuccess();
        }
    }

    @Override
    public void writeHttpEndOfContent(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (this.aggregatedHttpMessage.isChunked()) {
            DefaultHttpChunkTrailer chunk = new DefaultHttpChunkTrailer();
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture(), (Object)chunk);
        } else {
            if (HttpHeaders.isContentLengthSet((HttpMessage)this.aggregatedHttpMessage)) {
                ChannelBuffer content = this.aggregatedHttpMessage.getContent();
                HttpHeaders.setContentLength((HttpMessage)this.aggregatedHttpMessage, (long)content.capacity());
            }
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture(), (Object)this.aggregatedHttpMessage);
            if (this.aggregatedHttpMessage instanceof HttpResponse && !this.aggregatedHttpMessage.isChunked()) {
                HttpUtils.removeHttpFiltersFromPipeline(ctx.getPipeline());
            }
        }
    }
}

