/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.codec;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.kaazing.robot.driver.behavior.handler.codec.HttpUtils;
import org.kaazing.robot.driver.behavior.handler.codec.SimpleHttpChannelUpstreamHandler;

public class HttpMessageSplittingCodec
extends SimpleHttpChannelUpstreamHandler {
    @Override
    public void httpRequestReceived(ChannelHandlerContext ctx, MessageEvent e, HttpRequest httpRequest) throws Exception {
        if (httpRequest.isChunked()) {
            this.handleHttpMessageThatIsChunked(ctx, e, (HttpMessage)httpRequest);
        } else {
            this.handleBasicHttpMessage(ctx, e, (HttpMessage)httpRequest);
        }
    }

    @Override
    public void httpResponseReceived(ChannelHandlerContext ctx, MessageEvent e, HttpResponse httpResponse) throws Exception {
        if (HttpUtils.isOneOOneResponseMessage(httpResponse)) {
            Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)httpResponse);
            HttpUtils.removeHttpFiltersFromPipeline(ctx.getPipeline());
            Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)HttpUtils.END_OF_HTTP_MESSAGE_BUFFER);
        } else if (httpResponse.isChunked()) {
            this.handleHttpMessageThatIsChunked(ctx, e, (HttpMessage)httpResponse);
        } else {
            this.handleBasicHttpMessage(ctx, e, (HttpMessage)httpResponse);
            HttpUtils.removeHttpFiltersFromPipeline(ctx.getPipeline());
        }
    }

    private void handleBasicHttpMessage(ChannelHandlerContext ctx, MessageEvent e, HttpMessage httpMessage) throws Exception {
        ChannelBuffer content = httpMessage.getContent();
        if (content != null) {
            Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)httpMessage);
            Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)content);
            Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)HttpUtils.END_OF_HTTP_MESSAGE_BUFFER);
        } else {
            Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)httpMessage);
            Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)HttpUtils.END_OF_HTTP_MESSAGE_BUFFER);
        }
    }

    private void handleHttpMessageThatIsChunked(ChannelHandlerContext ctx, MessageEvent e, HttpMessage httpMessage) throws Exception {
        Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)httpMessage);
    }

    @Override
    public void httpChunkReceived(ChannelHandlerContext ctx, MessageEvent e, HttpChunk chunk) throws Exception {
        ChannelBuffer content = chunk.getContent();
        if (content != null && content != ChannelBuffers.EMPTY_BUFFER) {
            Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)content);
        }
        if (chunk.isLast()) {
            Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)HttpUtils.END_OF_HTTP_MESSAGE_BUFFER);
        }
    }
}

