/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.codec;

import javax.el.ELContext;
import javax.el.ValueExpression;
import org.jboss.netty.buffer.ChannelBuffer;
import org.kaazing.robot.driver.behavior.handler.codec.MaskingDecoder;
import org.kaazing.robot.lang.el.util.ExpressionContext;

public final class MaskingDecoders {
    public static MaskingDecoder newMaskingDecoder(byte[] maskingKey) {
        return new ExactBytesMaskingDecoder(maskingKey);
    }

    public static MaskingDecoder newMaskingDecoder(ValueExpression expression, ExpressionContext environment) {
        return new ExpressionMaskingDecoder(expression, environment);
    }

    private MaskingDecoders() {
    }

    private static abstract class AbstractMaskingDecoder
    extends MaskingDecoder {
        private int offset;

        private AbstractMaskingDecoder() {
        }

        protected final ChannelBuffer applyMask(ChannelBuffer buffer, byte[] maskingKey) throws Exception {
            int readerIndex = buffer.readerIndex();
            int writerIndex = buffer.writerIndex();
            for (int index = readerIndex; index < writerIndex; ++index) {
                int maskIndex = (index + this.offset) % maskingKey.length;
                byte mask = maskingKey[maskIndex];
                if (mask == 0) continue;
                byte value = buffer.getByte(index);
                value = (byte)(value ^ mask);
                buffer.setByte(index, (int)value);
            }
            this.offset = (this.offset + writerIndex - readerIndex) % maskingKey.length;
            return buffer;
        }

        protected final ChannelBuffer undoMask(ChannelBuffer buffer, byte[] maskingKey) throws Exception {
            int readerIndex = buffer.readerIndex();
            int writerIndex = buffer.writerIndex();
            this.offset = (this.offset - (writerIndex - readerIndex)) % maskingKey.length;
            if (this.offset < 0) {
                this.offset += maskingKey.length;
            }
            for (int index = readerIndex; index < writerIndex; ++index) {
                int maskIndex = (index + this.offset) % maskingKey.length;
                byte mask = maskingKey[maskIndex];
                if (mask == 0) continue;
                byte value = buffer.getByte(index);
                value = (byte)(value ^ mask);
                buffer.setByte(index, (int)value);
            }
            return buffer;
        }
    }

    private static class ExpressionMaskingDecoder
    extends AbstractMaskingDecoder {
        private final ValueExpression expression;
        private final ExpressionContext environment;

        public ExpressionMaskingDecoder(ValueExpression expression, ExpressionContext environment) {
            this.expression = expression;
            this.environment = environment;
        }

        @Override
        public ChannelBuffer applyMask(ChannelBuffer buffer) throws Exception {
            byte[] maskingKey = (byte[])this.expression.getValue((ELContext)this.environment);
            return this.applyMask(buffer, maskingKey);
        }

        @Override
        public ChannelBuffer undoMask(ChannelBuffer buffer) throws Exception {
            byte[] maskingKey = (byte[])this.expression.getValue((ELContext)this.environment);
            return this.undoMask(buffer, maskingKey);
        }
    }

    private static class ExactBytesMaskingDecoder
    extends AbstractMaskingDecoder {
        private final byte[] maskingKey;

        public ExactBytesMaskingDecoder(byte[] maskingKey) {
            this.maskingKey = maskingKey;
        }

        @Override
        public ChannelBuffer applyMask(ChannelBuffer buffer) throws Exception {
            return this.applyMask(buffer, this.maskingKey);
        }

        @Override
        public ChannelBuffer undoMask(ChannelBuffer buffer) throws Exception {
            return this.undoMask(buffer, this.maskingKey);
        }
    }
}

