/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.codec;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.robot.driver.behavior.handler.codec.MessageDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.MessageMismatchException;

public class ReadExactBytesDecoder
extends MessageDecoder {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(ReadExactBytesDecoder.class);
    private final ChannelBuffer expected;

    public ReadExactBytesDecoder(byte[] expected) {
        this.expected = ChannelBuffers.copiedBuffer((byte[])expected);
    }

    @Override
    protected Object decodeBuffer(ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < this.expected.readableBytes()) {
            LOGGER.debug("not enough bytes are ready to read. Expecting " + this.expected.readableBytes() + " bytes. Read to read is " + buffer.readableBytes());
            return null;
        }
        ChannelBuffer observed = buffer.readSlice(this.expected.readableBytes());
        if (!observed.equals((Object)this.expected)) {
            throw new MessageMismatchException("Exact bytes mismatch", this.expected, observed);
        }
        return buffer;
    }
}

