/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.codec;

import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.CharsetUtil;
import org.kaazing.robot.driver.behavior.handler.codec.MessageDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.MessageMismatchException;

public class ReadExactTextDecoder
extends MessageDecoder {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(ReadExactTextDecoder.class);
    private final ChannelBuffer expected;

    public ReadExactTextDecoder(String expected, Charset charset) {
        this.expected = ChannelBuffers.copiedBuffer((CharSequence)expected, (Charset)charset);
    }

    @Override
    protected Object decodeBuffer(ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < this.expected.readableBytes()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("not enough bytes are ready to read. Expecting " + this.expected.readableBytes() + " bytes. Read to read is " + buffer.readableBytes());
            }
            return null;
        }
        ChannelBuffer observed = buffer.readSlice(this.expected.readableBytes());
        if (!observed.equals((Object)this.expected)) {
            LOGGER.error("observed bytes do not match expected bytes");
            if (LOGGER.isInfoEnabled()) {
                LOGGER.error("\texpected: " + this.expected.toString(CharsetUtil.UTF_8));
                LOGGER.error("\tobserved: " + observed.toString(CharsetUtil.UTF_8));
            }
            throw new MessageMismatchException("Exact text mismatch", this.expected, observed);
        }
        return buffer;
    }
}

