/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.codec;

import javax.el.ELContext;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.robot.driver.behavior.handler.codec.MessageDecoder;
import org.kaazing.robot.lang.el.ExpressionContext;

public abstract class ReadFixedLengthBytesDecoder<T>
extends MessageDecoder {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(ReadFixedLengthBytesDecoder.class);
    private final int length;
    private final ExpressionContext environment;
    private final String captureName;

    public ReadFixedLengthBytesDecoder(int length) {
        this.length = length;
        this.environment = null;
        this.captureName = null;
    }

    public ReadFixedLengthBytesDecoder(int length, ExpressionContext environment, String captureName) {
        this.length = length;
        this.environment = environment;
        this.captureName = captureName;
    }

    protected abstract T readBuffer(ChannelBuffer var1);

    public int getLength() {
        return this.length;
    }

    @Override
    protected Object decodeBuffer(ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < this.length) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("not enough bytes are ready to read. Expecting " + this.length + " bytes. Read to read is " + buffer.readableBytes());
            }
            return null;
        }
        if (this.captureName == null) {
            buffer.readSlice(this.length);
        } else {
            T value = this.readBuffer(buffer);
            this.environment.getELResolver().setValue((ELContext)this.environment, null, (Object)this.captureName, value);
        }
        return buffer;
    }
}

