/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.codec;

import java.nio.charset.Charset;
import javax.el.ELContext;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.CharsetUtil;
import org.kaazing.robot.driver.behavior.handler.codec.MessageDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.MessageMismatchException;
import org.kaazing.robot.lang.el.ExpressionContext;
import org.kaazing.robot.lang.regex.NamedGroupMatcher;
import org.kaazing.robot.lang.regex.NamedGroupPattern;

public class ReadRegexDecoder
extends MessageDecoder {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(ReadRegexDecoder.class);
    private final NamedGroupPattern pattern;
    private final Charset charset;
    private final ExpressionContext environment;

    public ReadRegexDecoder(NamedGroupPattern pattern, Charset charset, ExpressionContext environment) {
        this.pattern = pattern;
        this.environment = environment;
        this.charset = charset;
    }

    @Override
    protected Object decodeBufferLast(ChannelBuffer buffer) throws Exception {
        return this.decodeBuffer(buffer, true);
    }

    @Override
    protected Object decodeBuffer(ChannelBuffer buffer) throws Exception {
        return this.decodeBuffer(buffer, false);
    }

    private Object decodeBuffer(ChannelBuffer buffer, boolean isLast) throws Exception {
        boolean noMatchMayMatchLater;
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        ChannelBuffer observedBytes = buffer.slice();
        String observed = observedBytes.toString(this.charset);
        NamedGroupMatcher matcher = this.pattern.matcher((CharSequence)observed);
        boolean allInputMatched = matcher.matches();
        boolean prefixMatched = allInputMatched || matcher.lookingAt();
        boolean bl = noMatchMayMatchLater = !prefixMatched && matcher.hitEnd();
        if ((allInputMatched || !isLast) && noMatchMayMatchLater) {
            if (isDebugEnabled) {
                LOGGER.debug("Waiting for more data to match full regex");
            }
            return null;
        }
        if (!prefixMatched) {
            throw new MessageMismatchException(String.format("Regex %s mismatch.", this.pattern.pattern()), this.pattern.pattern(), observed);
        }
        this.captureGroups(matcher);
        buffer.skipBytes(matcher.end());
        if (isDebugEnabled) {
            LOGGER.debug(String.format("Regex handler read %d bytes, leaving buffer=%s", matcher.end(), buffer.toString(CharsetUtil.UTF_8)));
        }
        return buffer;
    }

    private void captureGroups(NamedGroupMatcher matcher) {
        for (String captureName : matcher.groupNames()) {
            String captured = matcher.group(captureName);
            byte[] bytes = captured.getBytes(CharsetUtil.UTF_8);
            this.environment.getELResolver().setValue((ELContext)this.environment, null, (Object)captureName, (Object)bytes);
        }
    }
}

