/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.codec;

import javax.el.ELContext;
import javax.el.ValueExpression;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.robot.driver.behavior.handler.codec.MessageEncoder;
import org.kaazing.robot.driver.util.Utils;
import org.kaazing.robot.lang.el.ExpressionContext;

public class WriteExpressionEncoder
implements MessageEncoder {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(WriteExpressionEncoder.class);
    private final ExpressionContext context;
    private final ValueExpression expression;

    public WriteExpressionEncoder(ValueExpression expression, ExpressionContext context) {
        this.context = context;
        this.expression = expression;
    }

    @Override
    public ChannelBuffer encode() {
        ChannelBuffer result;
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        byte[] value = (byte[])this.expression.getValue((ELContext)this.context);
        if (value != null) {
            if (isDebugEnabled) {
                LOGGER.debug("Encoding expression results. " + value.length + " bytes. Bytes: " + Utils.byteArrayToString(value));
            }
            result = ChannelBuffers.wrappedBuffer((byte[])value);
        } else {
            if (isDebugEnabled) {
                LOGGER.debug("Value of expression is null. Encoding as a 0 length buffer");
            }
            result = ChannelBuffers.buffer((int)0);
        }
        return result;
    }

    @Override
    public String encodeToString() {
        String result;
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        byte[] value = (byte[])this.expression.getValue((ELContext)this.context);
        if (value == null) {
            if (isDebugEnabled) {
                LOGGER.debug("Value of expression is null. Encoding as a 0 length String");
            }
            result = new String();
        } else {
            result = new String(value);
            if (isDebugEnabled) {
                LOGGER.debug("Encoding expression results. " + value.length + " bytes. String: " + result);
            }
        }
        return result;
    }
}

