/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.codec.http;

import java.nio.charset.Charset;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.CharsetUtil;
import org.kaazing.robot.driver.behavior.handler.codec.MessageDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.MessageMismatchException;
import org.kaazing.robot.driver.behavior.handler.codec.http.HttpMessageContributingDecoder;

public class ReadHttpHeaderDecoder
implements HttpMessageContributingDecoder {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(ReadHttpHeaderDecoder.class);
    private String name;
    private MessageDecoder valueDecoder;

    public ReadHttpHeaderDecoder(String name, MessageDecoder valueDecoder) {
        this.name = name;
        this.valueDecoder = valueDecoder;
    }

    @Override
    public void decode(HttpMessage message) throws Exception {
        int i;
        HttpHeaders headers = message.headers();
        if (headers.isEmpty()) {
            new MessageMismatchException("Could not match non-existent header", this.name, null);
        }
        int firstMatchingHeader = -1;
        MessageMismatchException lastException = null;
        List headerValues = headers.getAll(this.name);
        for (i = 0; i < headerValues.size(); ++i) {
            try {
                String currentHeaderValue = (String)headerValues.get(i);
                ChannelBuffer copiedBuffer = ChannelBuffers.copiedBuffer((CharSequence)currentHeaderValue, (Charset)CharsetUtil.UTF_8);
                this.valueDecoder.decode(copiedBuffer);
                if (firstMatchingHeader > -1) {
                    LOGGER.warn(String.format("Multiple matching headers for read header %s, will remove first matching header", this.name));
                    break;
                }
                firstMatchingHeader = i;
                continue;
            }
            catch (MessageMismatchException mme) {
                lastException = mme;
            }
        }
        if (firstMatchingHeader == -1) {
            throw lastException;
        }
        message.headers().remove(this.name);
        for (i = 0; i < headerValues.size(); ++i) {
            if (i == firstMatchingHeader) continue;
            message.headers().add(this.name, headerValues.get(i));
        }
    }

    public String toString() {
        return String.format("read http header decoder with: %s, %s", this.name, this.valueDecoder);
    }
}

