/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.codec.http;

import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.util.CharsetUtil;
import org.kaazing.robot.driver.behavior.handler.codec.MessageDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.MessageMismatchException;
import org.kaazing.robot.driver.behavior.handler.codec.http.HttpMessageContributingDecoder;

public class ReadHttpMethodDecoder
implements HttpMessageContributingDecoder {
    private MessageDecoder methodValueDecoder;

    public ReadHttpMethodDecoder(MessageDecoder methodValueDecoder) {
        this.methodValueDecoder = methodValueDecoder;
    }

    @Override
    public void decode(HttpMessage message) throws Exception {
        HttpRequest request = null;
        if (!(message instanceof HttpRequest)) {
            throw new MessageMismatchException("Can not match a request method on a http response", this.methodValueDecoder, null);
        }
        request = (HttpRequest)message;
        HttpMethod method = request.getMethod();
        ChannelBuffer buffer = ChannelBuffers.copiedBuffer((CharSequence)method.getName(), (Charset)CharsetUtil.UTF_8);
        this.methodValueDecoder.decode(buffer);
    }

    public String toString() {
        return String.format("read http method decoder with: %s", this.methodValueDecoder);
    }
}

