/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.codec.http;

import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.CharsetUtil;
import org.kaazing.robot.driver.behavior.handler.codec.MessageDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.MessageMismatchException;
import org.kaazing.robot.driver.behavior.handler.codec.http.HttpMessageContributingDecoder;

public class ReadHttpParameterDecoder
implements HttpMessageContributingDecoder {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(ReadHttpParameterDecoder.class);
    private String key;
    private MessageDecoder valueDecoder;

    public ReadHttpParameterDecoder(String key, MessageDecoder valueDecoder) {
        this.key = key;
        this.valueDecoder = valueDecoder;
    }

    @Override
    public void decode(HttpMessage message) throws Exception {
        if (!(message instanceof HttpRequest)) {
            throw new IllegalArgumentException("Can not match any parameter on a HttpResponse");
        }
        HttpRequest request = (HttpRequest)message;
        List<String> parameterValues = this.getParameters(request);
        if (parameterValues.isEmpty()) {
            new MessageMismatchException("Could not match non-existent parameter", this.key, null);
        }
        int firstMatchingParameter = -1;
        MessageMismatchException lastException = null;
        for (int i = 0; i < parameterValues.size(); ++i) {
            try {
                String currentParameterValue = parameterValues.get(i);
                ChannelBuffer copiedBuffer = ChannelBuffers.copiedBuffer((CharSequence)currentParameterValue, (Charset)CharsetUtil.UTF_8);
                this.valueDecoder.decode(copiedBuffer);
                if (firstMatchingParameter > -1) {
                    LOGGER.warn(String.format("Multiple matching parameters for read parameter %s, will remove first matching paramter", this.key));
                    break;
                }
                firstMatchingParameter = i;
                continue;
            }
            catch (MessageMismatchException mme) {
                lastException = mme;
            }
        }
        if (firstMatchingParameter == -1) {
            assert (lastException != null);
            throw lastException;
        }
        URI uri = URI.create(request.getUri());
        String query = uri.getQuery();
        List<String> parameters = Arrays.asList(query.split("&"));
        String parameterToMatch = String.format("%s=%s", this.key, parameterValues.get(firstMatchingParameter));
        for (String parameter : parameters) {
            if (!parameterToMatch.equals(parameter)) continue;
            parameters.remove(parameter);
            break;
        }
        String result = null;
        for (String parameter : parameters) {
            if (result == null) {
                result = parameter;
                continue;
            }
            result = String.format("%s&%s", result, parameter);
        }
        request.setUri(uri.toString().replace(query, result));
    }

    private List<String> getParameters(HttpRequest httpRequest) {
        ArrayList<String> matchingParameters = new ArrayList<String>();
        String uri = httpRequest.getUri();
        URI requestURI = URI.create(uri);
        String query = requestURI.getQuery();
        String[] parameters = query.split("&");
        for (int i = 0; i < parameters.length; ++i) {
            String[] aParameter = parameters[i].split("=");
            String parameterKey = aParameter[0];
            if (!this.key.equals(parameterKey)) continue;
            matchingParameters.add(aParameter[1]);
            break;
        }
        return matchingParameters;
    }

    public String toString() {
        return String.format("read http parameter decoder with: %s, %s", this.key, this.valueDecoder);
    }
}

