/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.codec.http;

import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.util.CharsetUtil;
import org.kaazing.robot.driver.behavior.handler.codec.MessageDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.MessageMismatchException;
import org.kaazing.robot.driver.behavior.handler.codec.http.HttpMessageContributingDecoder;

public class ReadHttpStatusDecoder
implements HttpMessageContributingDecoder {
    private final MessageDecoder codeDecoder;
    private final MessageDecoder reasonDecoder;

    public ReadHttpStatusDecoder(MessageDecoder codeDecoder, MessageDecoder reasonDecoder) {
        this.codeDecoder = codeDecoder;
        this.reasonDecoder = reasonDecoder;
    }

    @Override
    public void decode(HttpMessage message) throws Exception {
        if (!(message instanceof HttpResponse)) {
            throw new MessageMismatchException("Can not match a http status on a http request", this.codeDecoder + "," + this.reasonDecoder, null);
        }
        HttpResponse response = (HttpResponse)message;
        HttpResponseStatus status = response.getStatus();
        String code = Integer.toString(status.getCode());
        String reason = status.getReasonPhrase();
        ChannelBuffer buffer = ChannelBuffers.copiedBuffer((CharSequence)code, (Charset)CharsetUtil.UTF_8);
        this.codeDecoder.decode(buffer);
        buffer = ChannelBuffers.copiedBuffer((CharSequence)reason, (Charset)CharsetUtil.UTF_8);
        this.reasonDecoder.decode(buffer);
    }

    public String toString() {
        return String.format("read http status decoder with: %s, %s", this.codeDecoder, this.reasonDecoder);
    }
}

