/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.codec.http;

import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.util.CharsetUtil;
import org.kaazing.robot.driver.behavior.handler.codec.MessageDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.http.HttpMessageContributingDecoder;

public class ReadHttpVersionDecoder
implements HttpMessageContributingDecoder {
    private MessageDecoder versionDecoder;

    public ReadHttpVersionDecoder(MessageDecoder versionDecoder) {
        this.versionDecoder = versionDecoder;
    }

    @Override
    public void decode(HttpMessage message) throws Exception {
        HttpVersion version = message.getProtocolVersion();
        ChannelBuffer buffer = ChannelBuffers.copiedBuffer((CharSequence)version.getText(), (Charset)CharsetUtil.UTF_8);
        this.versionDecoder.decode(buffer);
    }

    public String toString() {
        return String.format("read http version decoder with: %s", this.versionDecoder);
    }
}

