/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.codec.http;

import java.net.URI;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.kaazing.robot.driver.behavior.handler.codec.MessageEncoder;
import org.kaazing.robot.driver.behavior.handler.codec.http.HttpMessageContributingEncoder;

public class WriteHttpParameterEncoder
implements HttpMessageContributingEncoder {
    private final MessageEncoder keyEncoder;
    private final MessageEncoder valueEncoder;

    public WriteHttpParameterEncoder(MessageEncoder keyEncoder, MessageEncoder valueEncoder) {
        this.keyEncoder = keyEncoder;
        this.valueEncoder = valueEncoder;
    }

    @Override
    public void encode(HttpMessage message) throws Exception {
        if (!(message instanceof HttpRequest)) {
            throw new IllegalStateException("Can not write method onto a non-http request object");
        }
        HttpRequest request = (HttpRequest)message;
        URI oldURI = URI.create(request.getUri());
        String authority = oldURI.getAuthority();
        String fragment = oldURI.getFragment();
        String path = oldURI.getPath();
        String scheme = oldURI.getScheme();
        String query = oldURI.getQuery();
        query = query == null ? String.format("%s=%s", this.keyEncoder.encodeToString(), this.valueEncoder.encodeToString()) : String.format("%s&%s=%s", query, this.keyEncoder.encodeToString(), this.valueEncoder.encodeToString());
        URI newURI = new URI(scheme, authority, path, query, fragment);
        request.setUri(newURI.toString());
    }

    public String toString() {
        return String.format("write http parameter encoder with %s %s", this.keyEncoder, this.valueEncoder);
    }
}

