/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.codec.http;

import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.kaazing.robot.driver.behavior.handler.codec.MessageEncoder;
import org.kaazing.robot.driver.behavior.handler.codec.http.HttpMessageContributingEncoder;

public class WriteHttpStatusEncoder
implements HttpMessageContributingEncoder {
    private final MessageEncoder codeEncoder;
    private final MessageEncoder reasonEncoder;

    public WriteHttpStatusEncoder(MessageEncoder codeEncoder, MessageEncoder reasonEncoder) {
        this.codeEncoder = codeEncoder;
        this.reasonEncoder = reasonEncoder;
    }

    @Override
    public void encode(HttpMessage message) {
        if (!(message instanceof HttpResponse)) {
            throw new IllegalStateException("Can not write status onto a non-http response object");
        }
        HttpResponse response = (HttpResponse)message;
        HttpResponseStatus status = new HttpResponseStatus(Integer.parseInt(this.codeEncoder.encodeToString()), this.reasonEncoder.encodeToString());
        response.setStatus(status);
    }

    public String toString() {
        return String.format("write http status encoder with %s %s", this.codeEncoder, this.reasonEncoder);
    }
}

