/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.codec.http;

import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.kaazing.robot.driver.behavior.handler.codec.MessageEncoder;
import org.kaazing.robot.driver.behavior.handler.codec.http.HttpMessageContributingEncoder;

public class WriteHttpVersionEncoder
implements HttpMessageContributingEncoder {
    private MessageEncoder versionEncoder;

    public WriteHttpVersionEncoder(MessageEncoder versionEncoder) {
        this.versionEncoder = versionEncoder;
    }

    @Override
    public void encode(HttpMessage message) {
        String versionString = this.versionEncoder.encodeToString();
        HttpVersion oldVersion = message.getProtocolVersion();
        HttpVersion httpVersion = new HttpVersion(versionString, oldVersion.isKeepAliveDefault());
        message.setProtocolVersion(httpVersion);
    }

    public String toString() {
        return String.format("write http version encoder with %s", this.versionEncoder);
    }
}

