/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.command;

import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.robot.driver.behavior.handler.codec.MessageEncoder;
import org.kaazing.robot.driver.behavior.handler.command.AbstractCommandHandler;

public class WriteHandler
extends AbstractCommandHandler {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(WriteHandler.class);
    private final List<MessageEncoder> encoders;

    public WriteHandler(List<MessageEncoder> encoders) {
        if (encoders == null) {
            throw new NullPointerException("encoders");
        }
        if (encoders.size() == 0) {
            throw new IllegalArgumentException("must have at least one encoder");
        }
        this.encoders = encoders;
    }

    @Override
    protected void invokeCommand(ChannelHandlerContext ctx) throws Exception {
        ChannelBuffer[] buffers = new ChannelBuffer[this.encoders.size()];
        int idx = 0;
        for (MessageEncoder encoder : this.encoders) {
            buffers[idx] = encoder.encode();
            ++idx;
        }
        LOGGER.debug("Invoking write command");
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)this.getHandlerFuture(), (Object)ChannelBuffers.wrappedBuffer((ChannelBuffer[])buffers));
    }
}

