/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.event;

import java.util.EnumSet;
import java.util.Set;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ChildChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.robot.driver.behavior.handler.ExecutionHandler;

public abstract class AbstractEventHandler
extends ExecutionHandler {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(AbstractEventHandler.class);
    private final Set<ChannelEventKind> interestEvents;
    private final Set<ChannelEventKind> expectedEvents;

    protected AbstractEventHandler(Set<ChannelEventKind> expectedEvents) {
        this(EnumSet.complementOf(EnumSet.of(ChannelEventKind.CHILD_OPEN, new ChannelEventKind[]{ChannelEventKind.CHILD_CLOSED, ChannelEventKind.WRITE_COMPLETED, ChannelEventKind.INTEREST_OPS, ChannelEventKind.EXCEPTION, ChannelEventKind.IDLE_STATE, ChannelEventKind.UNKNOWN})), expectedEvents);
    }

    protected AbstractEventHandler(Set<ChannelEventKind> interestEvents, Set<ChannelEventKind> expectedEvents) {
        this.interestEvents = interestEvents;
        this.expectedEvents = expectedEvents;
    }

    @Override
    protected void handleUpstream1(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        ChannelEventKind eventAsKind = AbstractEventHandler.asEventKind(evt);
        ChannelFuture handlerFuture = this.getHandlerFuture();
        boolean isLogDebugEnabled = LOGGER.isDebugEnabled();
        if (isLogDebugEnabled) {
            LOGGER.debug("handleUpstream1 event " + (Object)((Object)eventAsKind));
        }
        assert (handlerFuture != null);
        if (handlerFuture.isDone() || !this.interestEvents.contains((Object)eventAsKind)) {
            if (isLogDebugEnabled) {
                LOGGER.debug((Object)((Object)eventAsKind) + "event not interesting send upstream");
            }
            ctx.sendUpstream(evt);
        } else if (!this.expectedEvents.contains((Object)eventAsKind)) {
            this.handleUnexpectedEvent(ctx, evt);
        } else {
            ChannelFuture pipelineFuture = this.getPipelineFuture();
            if (!pipelineFuture.isSuccess()) {
                LOGGER.error(((Object)((Object)this)).getClass() + String.format("  future is not success. setting handler future to failure done(%s), cannceled(%s), cause(%s)", pipelineFuture.isDone(), pipelineFuture.isCancelled(), pipelineFuture.getCause()));
                handlerFuture.setFailure(new ChannelException("Expected event arrived too early").fillInStackTrace());
            } else {
                if (isLogDebugEnabled) {
                    LOGGER.debug(((Object)((Object)this)).getClass() + " handler's pipelinefuture is a success. Sending event " + (Object)((Object)eventAsKind) + " to handler");
                }
                super.handleUpstream1(ctx, evt);
            }
        }
    }

    protected void handleUnexpectedEvent(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        ChannelEventKind eventAsKind = AbstractEventHandler.asEventKind(evt);
        String message = String.format("Unexpected event |%s| for handler %s", new Object[]{eventAsKind, ((Object)((Object)this)).getClass()});
        LOGGER.error(message);
        switch (eventAsKind) {
            case EXCEPTION: {
                Throwable cause = ((ExceptionEvent)evt).getCause();
                this.getHandlerFuture().setFailure(new ChannelException(message, cause).fillInStackTrace());
                break;
            }
            default: {
                this.getHandlerFuture().setFailure(new ChannelException(message).fillInStackTrace());
            }
        }
    }

    private static ChannelEventKind asEventKind(ChannelEvent evt) {
        if (evt instanceof MessageEvent) {
            return ChannelEventKind.MESSAGE;
        }
        if (evt instanceof WriteCompletionEvent) {
            return ChannelEventKind.WRITE_COMPLETED;
        }
        if (evt instanceof ChannelStateEvent) {
            ChannelStateEvent cse = (ChannelStateEvent)evt;
            Object value = cse.getValue();
            switch (cse.getState()) {
                case OPEN: {
                    return Boolean.TRUE.equals(value) ? ChannelEventKind.OPEN : ChannelEventKind.CLOSED;
                }
                case BOUND: {
                    return value != null ? ChannelEventKind.BOUND : ChannelEventKind.UNBOUND;
                }
                case CONNECTED: {
                    return value != null ? ChannelEventKind.CONNECTED : ChannelEventKind.DISCONNECTED;
                }
                case INTEREST_OPS: {
                    return ChannelEventKind.INTEREST_OPS;
                }
            }
        }
        if (evt instanceof ChildChannelStateEvent) {
            ChildChannelStateEvent ccse = (ChildChannelStateEvent)evt;
            Channel child = ccse.getChildChannel();
            return child.isOpen() ? ChannelEventKind.CHILD_OPEN : ChannelEventKind.CHILD_CLOSED;
        }
        if (evt instanceof ExceptionEvent) {
            return ChannelEventKind.EXCEPTION;
        }
        if (evt instanceof IdleStateEvent) {
            return ChannelEventKind.IDLE_STATE;
        }
        return ChannelEventKind.UNKNOWN;
    }

    public static enum ChannelEventKind {
        CHILD_OPEN,
        CHILD_CLOSED,
        OPEN,
        BOUND,
        CONNECTED,
        MESSAGE,
        WRITE_COMPLETED,
        DISCONNECTED,
        UNBOUND,
        CLOSED,
        EXCEPTION,
        INTEREST_OPS,
        IDLE_STATE,
        UNKNOWN;

    }
}

