/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.event;

import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.UpstreamMessageEvent;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.CharsetUtil;
import org.kaazing.robot.driver.behavior.handler.codec.MaskingDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.MessageDecoder;
import org.kaazing.robot.driver.behavior.handler.event.AbstractEventHandler;

public class ReadHandler
extends AbstractEventHandler {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(ReadHandler.class);
    private final List<MessageDecoder> decoders;
    private final MaskingDecoder unmasker;

    public ReadHandler(List<MessageDecoder> decoders, MaskingDecoder unmasker) {
        super(EnumSet.of(AbstractEventHandler.ChannelEventKind.MESSAGE));
        if (decoders == null) {
            throw new NullPointerException("decoders");
        }
        if (decoders.size() == 0) {
            throw new IllegalArgumentException("must have at least one decoder");
        }
        this.decoders = decoders;
        this.unmasker = unmasker;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        this.messageReceived(ctx, e, false);
    }

    @Override
    protected void handleUnexpectedEvent(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        Channel channel = evt.getChannel();
        UpstreamMessageEvent msg = new UpstreamMessageEvent(channel, (Object)ChannelBuffers.copiedBuffer((CharSequence)"", (Charset)CharsetUtil.UTF_8), channel.getRemoteAddress());
        this.messageReceived(ctx, (MessageEvent)msg, true);
        if (!this.getHandlerFuture().isDone()) {
            super.handleUnexpectedEvent(ctx, evt);
        }
    }

    private void messageReceived(ChannelHandlerContext ctx, MessageEvent e, boolean isLast) throws Exception {
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        ChannelBuffer buf = (ChannelBuffer)e.getMessage();
        buf = this.unmasker.applyMask(buf);
        ChannelFuture handlerFuture = this.getHandlerFuture();
        assert (handlerFuture != null);
        Iterator<MessageDecoder> iterator = this.decoders.iterator();
        while (iterator.hasNext()) {
            MessageDecoder decoder = iterator.next();
            try {
                buf = isLast ? decoder.decodeLast(buf) : decoder.decode(buf);
            }
            catch (Exception mme) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error("read handler failed ", (Throwable)mme);
                } else {
                    LOGGER.error("read handler failed " + mme);
                }
                handlerFuture.setFailure((Throwable)mme);
                return;
            }
            if (buf == null) {
                return;
            }
            if (isDebugEnabled) {
                LOGGER.debug("decoder " + decoder + " completed");
            }
            iterator.remove();
        }
        LOGGER.debug("Read handler completed");
        handlerFuture.setSuccess();
        if (buf.readable()) {
            LOGGER.debug("More bytes are available for reading. Firing message received.");
            buf = this.unmasker.undoMask(buf);
            Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)buf, (SocketAddress)ctx.getChannel().getRemoteAddress());
        }
    }
}

