/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.event.http;

import java.util.EnumSet;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.robot.driver.behavior.handler.codec.http.HttpMessageContributingDecoder;
import org.kaazing.robot.driver.behavior.handler.event.AbstractEventHandler;

public class ReadHttpHandler
extends AbstractEventHandler {
    private final HttpMessageContributingDecoder decoder;
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(ReadHttpHandler.class);

    public ReadHttpHandler(HttpMessageContributingDecoder decoder) {
        super(EnumSet.of(AbstractEventHandler.ChannelEventKind.MESSAGE));
        this.decoder = decoder;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        LOGGER.debug(String.format("Message Received with: %s", this.toString()));
        Object message = e.getMessage();
        if (message instanceof HttpMessage) {
            HttpMessage httpMessage = (HttpMessage)message;
            ChannelFuture handlerFuture = this.getHandlerFuture();
            assert (handlerFuture != null);
            try {
                this.decoder.decode(httpMessage);
                handlerFuture.setSuccess();
            }
            catch (Exception mme) {
                handlerFuture.setFailure((Throwable)mme);
            }
            super.messageReceived(ctx, e);
        }
    }

    public String toString() {
        return String.format("read http handler with: %s", this.decoder);
    }
}

