/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.handler.prepare;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.robot.driver.behavior.handler.prepare.PreparationEvent;
import org.kaazing.robot.driver.netty.channel.CompositeChannelFuture;
import org.kaazing.robot.lang.LocationInfo;

public abstract class AbstractPreparationEvent
implements PreparationEvent {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(AbstractPreparationEvent.class);
    private final Channel channel;
    private final ChannelFuture future;
    private final Collection<ChannelFuture> pipelineFutures;
    private volatile LocationInfo progressInfo;

    public AbstractPreparationEvent(Channel channel, ChannelFuture future) {
        this.channel = channel;
        this.future = future;
        this.pipelineFutures = new HashSet<ChannelFuture>();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public ChannelFuture getFuture() {
        return this.future;
    }

    @Override
    public Collection<ChannelFuture> getPipelineFutures() {
        return this.pipelineFutures;
    }

    @Override
    public LocationInfo getProgressInfo() {
        return this.progressInfo;
    }

    @Override
    public ChannelFuture checkpoint(final LocationInfo locationInfo, final ChannelFuture handlerFuture) {
        if (LOGGER.isDebugEnabled()) {
            Iterator<ChannelFuture> i = this.pipelineFutures.iterator();
            if (i.hasNext()) {
                LOGGER.debug("Creating pipelineFuture. With the below futures");
                while (i.hasNext()) {
                    LOGGER.debug("\t" + i.next());
                }
            } else {
                LOGGER.debug("Creating pipelinedFuture with no futures. Automatically set to success");
            }
        }
        CompositeChannelFuture<ChannelFuture> pipelineFuture = new CompositeChannelFuture<ChannelFuture>(this.channel, this.pipelineFutures, true);
        this.pipelineFutures.add(handlerFuture);
        if (locationInfo != null) {
            handlerFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("handler future completed: " + handlerFuture);
                    }
                    if (future.isSuccess()) {
                        AbstractPreparationEvent.this.progressInfo = locationInfo;
                    }
                }
            });
        }
        return pipelineFuture;
    }
}

