/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.parser;

import java.io.InputStream;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.robot.driver.behavior.visitor.AssociateStreamsVisitor;
import org.kaazing.robot.driver.behavior.visitor.InjectBarriersVisitor;
import org.kaazing.robot.driver.behavior.visitor.InjectEventsVisitor;
import org.kaazing.robot.driver.behavior.visitor.InjectHttpEventsVisitor;
import org.kaazing.robot.driver.behavior.visitor.ValidateBarriersVisitor;
import org.kaazing.robot.lang.ast.AstNode;
import org.kaazing.robot.lang.ast.AstScriptNode;
import org.kaazing.robot.lang.parser.ScriptParseException;
import org.kaazing.robot.lang.parser.ScriptParser;
import org.kaazing.robot.lang.parser.ScriptParserImpl;

public class Parser
implements ScriptParser {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(Parser.class);
    private final ScriptParser parser = new ScriptParserImpl();

    public AstScriptNode parse(InputStream input) throws ScriptParseException {
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        try {
            if (isDebugEnabled) {
                LOGGER.debug("parsing script");
            }
            AstScriptNode script = this.parser.parse(input);
            if (isDebugEnabled) {
                LOGGER.debug("done parsing script. Result: " + script);
            }
            InjectHttpEventsVisitor injectHttpEvents = new InjectHttpEventsVisitor();
            InjectHttpEventsVisitor.State injectHttpEventsState = new InjectHttpEventsVisitor.State();
            script = (AstScriptNode)script.accept((AstNode.Visitor)injectHttpEvents, (Object)injectHttpEventsState);
            injectHttpEventsState.finish();
            if (isDebugEnabled) {
                LOGGER.debug("inject http events visitor done. Result: " + script);
            }
            InjectEventsVisitor injectEvents = new InjectEventsVisitor();
            InjectEventsVisitor.State injectEventsState = new InjectEventsVisitor.State();
            script = (AstScriptNode)script.accept((AstNode.Visitor)injectEvents, (Object)injectEventsState);
            injectEventsState.finish();
            if (isDebugEnabled) {
                LOGGER.debug("inject events visitor done. Result: " + script);
            }
            InjectBarriersVisitor injectBarriers = new InjectBarriersVisitor();
            script = (AstScriptNode)script.accept((AstNode.Visitor)injectBarriers, (Object)new InjectBarriersVisitor.State());
            if (isDebugEnabled) {
                LOGGER.debug("inject barriers visitor done. Result: " + script);
            }
            AssociateStreamsVisitor associateStreams = new AssociateStreamsVisitor();
            script = (AstScriptNode)script.accept((AstNode.Visitor)associateStreams, (Object)new AssociateStreamsVisitor.State());
            if (isDebugEnabled) {
                LOGGER.debug("associate visitor done. Result: " + script);
            }
            ValidateBarriersVisitor validateBarriers = new ValidateBarriersVisitor();
            script.accept((AstNode.Visitor)validateBarriers, (Object)new ValidateBarriersVisitor.State());
            if (isDebugEnabled) {
                LOGGER.debug("validate barrier visitor done. Result: " + script);
            }
            return script;
        }
        catch (ScriptParseException e) {
            if (isDebugEnabled) {
                LOGGER.error("Script parse exception", (Throwable)e);
            } else {
                LOGGER.error("Script parse exception: " + (Object)((Object)e));
            }
            throw e;
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                LOGGER.error("caught exception parsing script", (Throwable)e);
            } else {
                LOGGER.error("caught exception parsing script: " + e);
            }
            throw new ScriptParseException((Throwable)e);
        }
    }
}

