/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.visitor;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.kaazing.robot.lang.LocationInfo;
import org.kaazing.robot.lang.ast.AstAcceptNode;
import org.kaazing.robot.lang.ast.AstAcceptableNode;
import org.kaazing.robot.lang.ast.AstBoundNode;
import org.kaazing.robot.lang.ast.AstChildClosedNode;
import org.kaazing.robot.lang.ast.AstChildOpenedNode;
import org.kaazing.robot.lang.ast.AstCloseHttpRequestNode;
import org.kaazing.robot.lang.ast.AstCloseHttpResponseNode;
import org.kaazing.robot.lang.ast.AstCloseNode;
import org.kaazing.robot.lang.ast.AstClosedNode;
import org.kaazing.robot.lang.ast.AstConnectNode;
import org.kaazing.robot.lang.ast.AstConnectedNode;
import org.kaazing.robot.lang.ast.AstDisconnectNode;
import org.kaazing.robot.lang.ast.AstDisconnectedNode;
import org.kaazing.robot.lang.ast.AstEndOfHttpHeadersNode;
import org.kaazing.robot.lang.ast.AstNode;
import org.kaazing.robot.lang.ast.AstOpenedNode;
import org.kaazing.robot.lang.ast.AstReadAwaitNode;
import org.kaazing.robot.lang.ast.AstReadHttpHeaderNode;
import org.kaazing.robot.lang.ast.AstReadHttpMethodNode;
import org.kaazing.robot.lang.ast.AstReadHttpParameterNode;
import org.kaazing.robot.lang.ast.AstReadHttpStatusNode;
import org.kaazing.robot.lang.ast.AstReadHttpVersionNode;
import org.kaazing.robot.lang.ast.AstReadNotifyNode;
import org.kaazing.robot.lang.ast.AstReadOptionNode;
import org.kaazing.robot.lang.ast.AstReadValueNode;
import org.kaazing.robot.lang.ast.AstScriptNode;
import org.kaazing.robot.lang.ast.AstStreamNode;
import org.kaazing.robot.lang.ast.AstStreamableNode;
import org.kaazing.robot.lang.ast.AstUnbindNode;
import org.kaazing.robot.lang.ast.AstUnboundNode;
import org.kaazing.robot.lang.ast.AstWriteAwaitNode;
import org.kaazing.robot.lang.ast.AstWriteHttpContentLengthNode;
import org.kaazing.robot.lang.ast.AstWriteHttpHeaderNode;
import org.kaazing.robot.lang.ast.AstWriteHttpMethodNode;
import org.kaazing.robot.lang.ast.AstWriteHttpParameterNode;
import org.kaazing.robot.lang.ast.AstWriteHttpStatusNode;
import org.kaazing.robot.lang.ast.AstWriteHttpVersionNode;
import org.kaazing.robot.lang.ast.AstWriteNotifyNode;
import org.kaazing.robot.lang.ast.AstWriteOptionNode;
import org.kaazing.robot.lang.ast.AstWriteValueNode;

public class GatherStreamsLocationVisitor
implements AstNode.Visitor<AstScriptNode, State> {
    public AstScriptNode visit(AstScriptNode script, State state) throws Exception {
        for (AstStreamNode stream : script.getStreams()) {
            stream.accept((AstNode.Visitor)this, (Object)state);
        }
        assert (state.currentIndex == state.streamEndPoints.size()) : "Too many end points";
        return null;
    }

    public AstScriptNode visit(AstAcceptNode acceptNode, State state) throws Exception {
        LocationInfo start = acceptNode.getLocationInfo();
        LocationInfo end = acceptNode.getEndLocation();
        if (state.serverLocations.containsKey(start)) {
            state.results.add(new StreamResultLocationInfo(start, end, null));
        } else if (state.currentIndex < state.streamEndPoints.size()) assert (!((LocationInfo)state.streamEndPoints.get(state.currentIndex)).isBetween(start, end)) : "Bind failed but one of the streams associated with it succeeded???";
        for (AstStreamableNode streamable : acceptNode.getStreamables()) {
            streamable.accept((AstNode.Visitor)this, (Object)state);
        }
        for (AstAcceptableNode acceptable : acceptNode.getAcceptables()) {
            acceptable.accept((AstNode.Visitor)this, (Object)state);
        }
        return null;
    }

    public AstScriptNode visit(AstAcceptableNode acceptableNode, State state) throws Exception {
        GatherStreamsLocationVisitor.recordResults((AstStreamNode)acceptableNode, state);
        return null;
    }

    public AstScriptNode visit(AstConnectNode connectNode, State state) throws Exception {
        GatherStreamsLocationVisitor.recordResults((AstStreamNode)connectNode, state);
        return null;
    }

    public AstScriptNode visit(AstReadAwaitNode node, State state) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstWriteAwaitNode node, State state) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstReadNotifyNode node, State state) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstWriteNotifyNode node, State state) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstWriteValueNode node, State state) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstDisconnectNode node, State state) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstUnbindNode node, State state) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstCloseNode node, State state) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstChildOpenedNode childOpenedNode, State state) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstChildClosedNode childClosedNode, State state) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstOpenedNode openedNode, State state) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstBoundNode boundNode, State state) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstConnectedNode connectedNode, State state) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstReadValueNode node, State state) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstDisconnectedNode disconnectedNode, State state) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstUnboundNode unboundNode, State state) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstClosedNode closedNode, State state) throws Exception {
        return null;
    }

    private static void recordResults(AstStreamNode node, State state) {
        LocationInfo end;
        if (state.streamEndPoints.size() == state.currentIndex) {
            return;
        }
        LocationInfo start = node.getLocationInfo();
        LocationInfo observed = (LocationInfo)state.streamEndPoints.get(state.currentIndex);
        if (observed.isBetween(start, end = node.getEndLocation())) {
            state.results.add(new StreamResultLocationInfo(start, end, observed));
            state.currentIndex++;
        }
    }

    public AstScriptNode visit(AstReadHttpHeaderNode node, State parameter) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstWriteHttpHeaderNode node, State parameter) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstWriteHttpContentLengthNode node, State parameter) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstReadHttpMethodNode node, State parameter) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstWriteHttpMethodNode node, State parameter) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstReadHttpParameterNode node, State parameter) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstWriteHttpParameterNode node, State parameter) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstReadHttpVersionNode node, State parameter) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstWriteHttpVersionNode node, State parameter) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstReadHttpStatusNode node, State parameter) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstWriteHttpStatusNode node, State parameter) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstCloseHttpRequestNode node, State parameter) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstCloseHttpResponseNode node, State parameter) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstEndOfHttpHeadersNode node, State parameter) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstReadOptionNode node, State parameter) throws Exception {
        return null;
    }

    public AstScriptNode visit(AstWriteOptionNode node, State parameter) throws Exception {
        return null;
    }

    public static final class State {
        public final List<StreamResultLocationInfo> results = new LinkedList<StreamResultLocationInfo>();
        private final List<LocationInfo> streamEndPoints;
        private final Map<LocationInfo, Object> serverLocations;
        private int currentIndex;

        public State(List<LocationInfo> streamEndPoints) {
            this(streamEndPoints, new HashMap<LocationInfo, Object>(0, 100.0f));
        }

        public State(List<LocationInfo> streamEndPoints, Map<LocationInfo, Object> serverLocations) {
            this.streamEndPoints = streamEndPoints;
            this.serverLocations = serverLocations;
            Collections.sort(this.streamEndPoints);
        }
    }

    public static final class StreamResultLocationInfo {
        public final LocationInfo start;
        public final LocationInfo observed;
        public final LocationInfo end;

        public StreamResultLocationInfo(LocationInfo start, LocationInfo end, LocationInfo observed) {
            if (observed != null) {
                assert (observed.isBetween(start, end)) : String.format("observed %s is not between start %s and end %s", observed, start, end);
            } else assert (start.compareTo(end) <= 0) : String.format("start %s is greater than end %s", start, end);
            this.start = start;
            this.end = end;
            this.observed = observed;
        }
    }
}

